<?php

namespace App\Modules\Payment;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Checkout\Contracts\PayableContract;
use Mtc\Checkout\Contracts\PayableFactoryContract;

class PayableFactory implements PayableFactoryContract
{
    public function create(Request $request): PayableContract
    {
        return match ($request->input('type')) {
            'basket' => App::make(ReservationFactory::class)->create($request->input()),
            default => throw new \Exception("Unsupported Payment Object"),
        };
    }
}
