<?php

namespace App\Modules\Valuation\Config;

use App\Facades\Settings;

class BCAConfig extends \Mtc\VehicleValuation\Config\BCAConfig
{
    #[\Override]
    public function enabled(): bool
    {
        return Settings::get('valuation-bca-enabled') ?? false;
    }

    #[\Override]
    public function apiKey(): string
    {
        return Settings::get('valuation-bca-api_key') ?? '';
    }

    #[\Override]
    public function apiSecret(): string
    {
        return Settings::get('valuation-bca-api_secret') ?? '';
    }

    #[\Override]
    public function live(): bool
    {
        return Settings::get('valuation-bca-live') ?? true;
    }

    #[\Override]
    public function locationId(): string
    {
        return Settings::get('valuation-bca-location-id') ?? '';
    }
}
