<?php

namespace App\Modules\Valuation\Config;

use App\Facades\Settings;
use Mtc\VehicleValuation\Config\MotorCheckConfig;

class MotorCheck extends MotorCheckConfig
{
    #[\Override]
    public function enabled(): bool
    {
        return Settings::get('valuation-motor-check-enabled') ?? false;
    }

    #[\Override]
    public function clientId(): string
    {
        return Settings::get('valuation-motor-check-client_id');
    }

    #[\Override]
    public function clientSecret(): string
    {
        return Settings::get('valuation-motor-check-client_secret');
    }

    #[\Override]
    public function valuationDriver(): string
    {
        return Settings::get('valuation-motor-check-driver', 'motor-check');
    }

    #[\Override]
    public function country(): string
    {
        return Settings::get('app-details-country');
    }
}
