<?php

namespace App;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\Filter\Contracts\FilterObject;
use Mtc\Filter\Contracts\FilterSeoContract;
use Mtc\MercuryDataModels\VehicleFinance;

class OfferFilter extends Filter
{
    /**
     * Filter constructor
     *
     * @param Request $request
     * @param FilterObject $product_handler
     * @param FilterSeoContract $seo
     */
    public function __construct(Request $request, FilterObject $product_handler, FilterSeoContract $seo)
    {
        $this->request = $request;
        $this->seo = $seo;
        $this->config = Config::get('filter');
        $this->product_handler = App::make(OfferFilterObject::class);
        $this->selections = $this->groupSelectionsByType($request->input('selections') ?? []);
        $this->active_sort_option_name = $this->config['default_sort_choice'];
    }

    #[\Override]
    public function getRepresentativeFinance(JsonResource $results): ?VehicleFinance
    {
        return null;
    }

    #[\Override]
    protected function getConfigFilters(): array
    {
        return $this->config['offer_filters'];
    }

    #[\Override]
    protected function getSettingsFilterName(string $name): string
    {
        return "automotive-vehicle-filters-offer-$name";
    }
}
