#!/usr/bin/env bash

# Exit immediately if a command exits with a non-zero status
set -e

# Determine if stdout is a terminal...
if test -t 1; then
    # Determine if colors are supported...
    ncolors=$(tput colors)

    if test -n "$ncolors" && test "$ncolors" -ge 8; then
        BOLD="$(tput bold)"
        YELLOW="$(tput setaf 3)"
        GREEN="$(tput setaf 2)"
        RED="$(tput setaf 1)"
        NC="$(tput sgr0)"
    fi
fi

# Function to handle errors
handle_error() {
    echo "${RED}${BOLD}ERROR: $1${NC}" >&2
    echo "${RED}Sync process failed.${NC}" >&2
    exit 1
}

# Trap errors and call handle_error
trap 'handle_error "Command failed at line $LINENO"' ERR

echo "${BOLD}Running update on FE container...${NC}" >&2

echo "${YELLOW}Installing composer dependencies...${NC}" >&2
composer install --no-interaction || handle_error "Composer install failed"

echo "${GREEN}${BOLD}Update finished successfully!${NC}" >&2
