<?php

namespace Tests;

use CS_REST_Subscribers;

class FakeCampaignMonitor extends CS_REST_Subscribers
{
    public static bool $return_subscribed = false;
    public static bool $allow_signing_up = true;

    #[\Override]
    public function add($subscriber)
    {
        if (self::$allow_signing_up) {
            return new \CS_REST_Wrapper_Result('', 200);

        }
        return new \CS_REST_Wrapper_Result((object)['Message' => 'error'], 400);
    }

    #[\Override]
    public function get($email, $include_tracking_pref = null)
    {
        return new \CS_REST_Wrapper_Result('', self::$return_subscribed ? 200 : 404);
    }
}
