<?php

namespace Tests;

use DrewM\MailChimp\MailChimp;

class FakeMailchimp extends MailChimp
{
    public static bool $return_subscribed = false;
    public static bool $allow_signing_up = true;

    #[\Override]
    public function post($method, $args = [], $timeout = self::TIMEOUT)
    {
        return self::$allow_signing_up;
    }

    #[\Override]
    public function get($method, $args = [], $timeout = self::TIMEOUT)
    {
        if ($method === 'lists') {
            return [
                'lists' => [
                    [
                        'id' => 'abc123',
                    ]
                ]
            ];
        }

        return [
            'status' => self::$return_subscribed ? 'subscribed' : false
        ];
    }
}
