<?php

namespace Tests\Feature;

use App\Models\FilterIndex;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\SeoRedirect;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;

class MiddlewareTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testSuspended()
    {
        Dealership::factory(3)->create();
        $response = $this->asTenant(tenant())->getJson(route('dealerships.index'));
        $response->assertStatus(200);

        tenant()->update([
            'suspended_at' => Carbon::now()
        ]);

        $response = $this->asTenant(tenant())->getJson(route('dealerships.index'));
        $response->assertStatus(423);
    }
}
