<?php

namespace Tests\Tenant;

use App\BookingRepository;
use App\Facades\Settings;
use Carbon\Carbon;
use Illuminate\Support\Facades\App;
use Tests\TenantTestCase;

class BookingTest extends TenantTestCase
{
    public function testAvailabilityThisYear()
    {
        Carbon::setTestNow('2020-06-01');
        $availability = (App::make(BookingRepository::class))->getAvailability('jul', 1);

        $this->assertEquals('2020-06-29', $availability->first()[0]['full-date']);
    }

    public function testAvailabilityWithNextYear()
    {
        Carbon::setTestNow('2020-06-01');
        $availability = (App::make(BookingRepository::class))->getAvailability('jan', 1);

        $this->assertEquals('2020-12-31', $availability->first()[3]['full-date']);
        $this->assertEquals('2021-01-01', $availability->first()[4]['full-date']);
    }
}
