<?php

namespace Tests\Tenant;

use App\Http\Resources\UiArticlesSlider;
use App\Http\Resources\UiHero;
use App\Http\Resources\UiNewsCardList;
use Illuminate\Support\Facades\Queue;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\MercuryDataModels\Page;
use Tests\Data\ContentElementSeeder;
use Tests\Data\DemoContentSeed;
use Tests\Data\GlobalContentSeeder;
use Tests\Data\PageSeeder;
use Tests\Data\TemplateSeeder;
use Tests\TenantTestCase;

class ContentResourceTest extends TenantTestCase
{
    protected function setUp(): void
    {
        parent::setUp();
        Queue::fake();
    }

    public function testUiArticlesSlider()
    {
        $this->prepare();
        /** @var Page $page */
        $page = Page::query()->where('slug', 'home')->first();
        $content = $page->content()
            ->where('name', 'News listing')
            ->with([
                'mediaUses.media',
                'subContent.mediaUses.media',
                'subContent.subContent.mediaUses.media',
                'subContent.subContent.subContent.mediaUses.media',
                'contentElement',
                'globalContent.contentElement',
                'subContent.contentElement',
                'subContent.globalContent.contentElement',
                'subContent.subContent.contentElement',
                'subContent.subContent.globalContent.contentElement',
                'subContent.subContent.subContent.contentElement',
                'subContent.subContent.subContent.globalContent.contentElement',
            ])
            ->first();
        $resource = new UiArticlesSlider($content)->toArray(request());
        $this->assertArrayHasKey('name', $resource);
        $this->assertArrayHasKey('items', $resource);
        $this->assertArrayHasKey('url', $resource['items'][0]);
        $this->assertArrayHasKey('title', $resource['items'][0]);
        $this->assertArrayHasKey('thumbnail', $resource['items'][0]);
        $this->assertArrayHasKey('date', $resource['items'][0]);
    }
    public function testUiHero()
    {
        $this->prepare();
        /** @var Page $page */
        $page = Page::query()->where('slug', 'home')->first();
        $content = $page->content()
            ->where('name', 'Hero')
            ->with([
                'mediaUses.media',
                'subContent.mediaUses.media',
                'subContent.subContent.mediaUses.media',
                'subContent.subContent.subContent.mediaUses.media',
                'contentElement',
                'globalContent.contentElement',
                'subContent.contentElement',
                'subContent.globalContent.contentElement',
                'subContent.subContent.contentElement',
                'subContent.subContent.globalContent.contentElement',
                'subContent.subContent.subContent.contentElement',
                'subContent.subContent.subContent.globalContent.contentElement',
            ])
            ->first();
        $resource = new UiHero($content)->toArray(request());
        $this->assertArrayHasKey('image', $resource);
        $this->assertArrayHasKey('title', $resource);
        $this->assertArrayHasKey('search', $resource);
        $this->assertArrayHasKey('brands', $resource);
    }
    public function testUiNewsCardList()
    {
        $this->prepare();
        /** @var Page $page */
        $page = Page::query()->where('slug', 'home')->first();
        $content = $page->content()
            ->where('name', 'News listing')
            ->with([
                'mediaUses.media',
                'subContent.mediaUses.media',
                'subContent.subContent.mediaUses.media',
                'subContent.subContent.subContent.mediaUses.media',
                'contentElement',
                'globalContent.contentElement',
                'subContent.contentElement',
                'subContent.globalContent.contentElement',
                'subContent.subContent.contentElement',
                'subContent.subContent.globalContent.contentElement',
                'subContent.subContent.subContent.contentElement',
                'subContent.subContent.subContent.globalContent.contentElement',
            ])
            ->first();
        $resource = new UiNewsCardList($content)->toArray(request());
        $this->assertIsArray($resource);
        $this->assertIsArray($resource[0]);
        $this->assertArrayHasKey('url', $resource[0]);
        $this->assertArrayHasKey('title', $resource[0]);
        $this->assertArrayHasKey('thumbnail', $resource[0]);
        $this->assertArrayHasKey('date', $resource[0]);
    }
    public function testUiPromoText(): never
    {
        $this->markTestIncomplete();
    }

    public function testShowPageEndpoint()
    {
        $this->prepare();
        Page::factory()->create(['title' => 'foo baz bar', 'slug' => 'home']);

        $response = $this
            ->getJson(route('pages.show', 'home'));
        $response->assertStatus(200);

        $this->assertEquals('home', $response->json('slug'));
        $this->assertEquals('Homepage', $response->json('title'));
    }

    public function testShowSeededPageEndpoints()
    {
        $this->prepare();

        $response = $this
            ->getJson(route('pages.show', 'home'));
        $response->assertStatus(200);

        $response = $this
            ->getJson(route('pages.show', 'about-us'));
        $response->assertStatus(200);

        $response = $this
            ->getJson(route('pages.show', 'news'));
        $response->assertStatus(200);
    }


    public function testImageSizes()
    {
        $this->prepare();
        ContentElement::query()
            ->where('ui_component', 'UiHero')
            ->update([
                'ui_component' => 'UiFooFaz'
            ]);

        $response = $this
            ->getJson(route('pages.show', 'home'));
        $response->assertStatus(200);

        $this->assertArrayHasKey('sizes', $response->json('data.0.data.0.value.0'));
    }


    private function prepare(): void
    {
        $this->seed(ContentElementSeeder::class);
        $this->seed(GlobalContentSeeder::class);
        $this->seed(TemplateSeeder::class);
        $this->seed(PageSeeder::class);
        $this->seed(DemoContentSeed::class);
    }
}
