<?php

namespace App\Http\Requests;

use App\Rules\AddOnIsApplicableToVehicle;

class AddAddOnToDeal extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'payment_term' => [
                'sometimes',
            ],
            'add_on_id' => [
                'required',
                'exists:deal_builder_add_ons,id',
                new AddOnIsApplicableToVehicle($this->deal()->vehicle)
            ]
        ];
    }
}
