<?php

namespace App\Http\Requests;

use App\Rules\CashbackDoesNotExceedValuation;
use Mtc\MercuryDataModels\VehicleValuation;

class AddPartExchangeVehicle extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $valuation = VehicleValuation::query()->find($this->input('valuation_id'));

        $retailPrice = (float) ($valuation->retail_price ?? 0);
        $outstandingFinance = (float) ($this->input('outstanding_finance') ?? 0);

        return [
            'valuation_id' => [
                'required',
                'exists:valuations,id',
            ],
            'registration' => [
                'required',
            ],
            'mileage' => [
                'required',
                'numeric',
            ],
            'email' => [
                'required',
                'email',
            ],
            'outstanding_finance' => [
                'present',
                'numeric',
                'min:0',
                'max:' . $retailPrice,
            ],
            'cashback_amount' => [
                'nullable',
                'numeric',
                'min:0',
                new CashbackDoesNotExceedValuation($retailPrice, $outstandingFinance),
            ],
        ];
    }
}
