<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LeaseItemFinanceRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'items' => [
                'required',
                'array',
            ],
            'items.*.*.id' => [
                'required'
            ],
            'items.*.*.price_ex_vat_ex_vrt' => [
                'required'
            ],
            'items.*.*.vrt' => [
                'required'
            ],
            'items.*.*.vat' => [
                'nullable',
                'numeric',
            ],
        ];
    }
}
