<?php

namespace App\Http\Requests;

use App\Repositories\DealBuilderRepository;
use App\Rules\CanStartDealForVehicle;
use Illuminate\Support\Facades\Session;
use Mtc\MercuryDataModels\DealBuilder\Deal;

class ResumeDealRequest extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'vehicle_id' => [
                'required',
                'exists:vehicles,id',
                new CanStartDealForVehicle(),
            ]
        ];
    }

    public function deal(): Deal
    {
        return $this->dealBuilder()->get(Session::get(DealBuilderRepository::DEAL_SESSION_KEY));
    }
}
