<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SetDealFinanceTerms extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'credit_rating' => 'sometimes',
            'annual_mileage' => [
                'required',
                'numeric',
                'min:1000',
            ],
            'term' => [
                'required',
                'numeric',
                'min:12',
                'max:72',
            ],
            'customer_deposit' => [
                'nullable',
                'numeric',
                'min:0',
            ],
        ];
    }
}
