<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Mtc\MercuryDataModels\DealBuilder\DealPaymentType;

class SetDealPaymentType extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'payment_type' => [
                'required',
                Rule::in(array_column(DealPaymentType::cases(), 'value'))
            ]
        ];
    }
}
