<?php

namespace App\Http\Requests;

use App\Repositories\DealBuilderRepository;
use App\Rules\CanStartDealForVehicle;
use Illuminate\Support\Facades\Session;
use Mtc\MercuryDataModels\DealBuilder\Deal;

class StartDealRequest extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'vehicle_id' => [
                'required',
                'exists:vehicles,slug',
                new CanStartDealForVehicle(),
            ],
            'force_new' => [
                'nullable',
                'boolean',
            ]
        ];
    }

    public function deal(): Deal
    {
        return $this->dealBuilder()->getOrCreate(
            Session::get(DealBuilderRepository::DEAL_SESSION_KEY),
            $this->input('vehicle_id'),
            $this->input('force_new', false)
        );
    }
}
