<?php

namespace App\Http\Requests;

use App\Rules\CashbackDoesNotExceedValuation;
use Mtc\MercuryDataModels\DealBuilder\DealPartExchange;

class UpdatePartExchangeVehicle extends DealBuilderRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $partExchange = DealPartExchange::query()->find($this->input('id'));

        $retailPrice = (float) ($partExchange->retail_price ?? 0);
        $outstandingFinance = (float) ($this->input('outstanding_finance') ?? $partExchange->outstanding_finance ?? 0);

        return [
            'id' => [
                'required',
                'exists:deal_part_exchanges,id',
            ],
            'outstanding_finance' => [
                'sometimes',
                'numeric',
                'min:0',
            ],
            'cashback_amount' => [
                'sometimes',
                'numeric',
                'min:0',
                new CashbackDoesNotExceedValuation($retailPrice, $outstandingFinance),
            ],
        ];
    }
}
