<?php

declare(strict_types=1);

use App\Http\Controllers\ConfiguratorController;
use App\Http\Controllers\ConversionController;
use App\Http\Controllers\CustomerAccountController;
use App\Http\Controllers\CustomerDealController;
use App\Http\Controllers\DealBuilderController;
use App\Http\Controllers\DealershipController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\FinanceController;
use App\Http\Controllers\FranchiseController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\LeaseVehicleFinanceController;
use App\Http\Controllers\LeaseVehicleController;
use App\Http\Controllers\IntegrationController;
use App\Http\Controllers\LookupController;
use App\Http\Controllers\NewCarController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PropertyController;
use App\Http\Controllers\ServiceBookingController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\ValuationController;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\VehicleDeeplinkController;
use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use App\Http\Middleware\SeoRedirectCheckMiddleware;
use App\Http\Middleware\SetStatefulDomainForTenant;
use App\Http\Middleware\TrackFormActivity;
use App\Http\Middleware\TrackRequests;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use App\Middleware\InitializeTenancyByDomain;
use Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful;
use Mtc\Stripe\Http\Controllers\StripePaymentRequestController;
use Mtc\Stripe\Http\Controllers\StripeController;
use Mtc\VehicleReservations\Http\Controllers\ReservationFlowController;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProauvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'api',
    InitializeTenancyByDomain::class,
    EnsureFrontendRequestsAreStateful::class,
    TrackRequests::class,
])->prefix('frontend/')->group(function (Router $router) {

    $router->get('/get-site', [SiteController::class, 'index'])->name('get-site');

    Route::middleware([
        PreventRequestsIfTenantSuspended::class,
        SeoRedirectCheckMiddleware::class,
    ])->group(function (Router $router) {
        $router->get('/paginated-listing/{type?}', [PageController::class, 'paginatedListing'])
            ->name('paginated-listing');
        $router->post('verify-access', [SiteController::class, 'checkAccess'])->name('check-site-access');
        $router->post('/newsletter', [NewsletterController::class, 'store'])->name('newsletter-signup');
        $router->post('/enquiries', [EnquiryController::class, 'store'])
            ->middleware(TrackFormActivity::class)
            ->name('enquiries.store');
        $router->get('/pages/{page}', [PageController::class, 'show'])
            ->name('pages.show')->where('page', '.*');
        $router->post('/enquiries/step', [EnquiryController::class, 'step'])->name('enquiries.step');
        $router->get('/global-content/{content}', [PageController::class, 'globalContent'])->name('pages.get-global');

        $router->any('/track-404', [PageController::class, 'track404'])->name('pages.track-404');

        $router->post('/find-vehicle', [FilterController::class, 'index'])->name('vehicles.index');
        $router->post('/find-vehicle/widget', [FilterController::class, 'widget'])->name('vehicles.widget');
        $router->post('/find-vehicle/stock-and-offers', [FilterController::class, 'filterStockAndOffers'])
            ->name('vehicles.stock-and-offers');
        $router->post('/vehicles/lookup/trims', [LookupController::class, 'getTrims'])->name('vehicles.lookup-trims');
        $router->post('/vehicles/lookup/variants', [LookupController::class, 'getVariants'])
            ->name('vehicles.lookup-variants');
        $router->get('/vehicles/lookup', [LookupController::class, 'show'])->name('vehicles.lookup');
        $router->get('/vehicles/deeplink/auto-trader/{at_id}', [VehicleDeeplinkController::class, 'autoTrader']);
        $router->get('/vehicles/deeplink/vrm/{vrm}', [VehicleDeeplinkController::class, 'vrm']);
        $router->post('/vehicles/{vehicle:slug}/finance', [FinanceController::class, 'store'])
            ->name('vehicles.get-finance');
        $router->post('/vehicles/get-cap-finance', [FinanceController::class, 'getForCap'])
            ->name('vehicles.get-cap-finance');
        $router->get('/vehicles/{vehicle:slug}/quick-view', [VehicleController::class, 'quickView'])
            ->name('vehicles.quick-view');
        $router->get('/vehicles/{vehicle:slug}', [VehicleController::class, 'show'])->name('vehicles.show');
        $router->get('/recent-vehicles/{vehicle:slug?}', [VehicleController::class, 'recentlyViewed'])
            ->name('vehicles.recentlyViewed');
        $router->get('/compare-vehicles', [VehicleController::class, 'compare'])->name('vehicles.compare');
        $router->post('/compare-vehicles-mail', [VehicleController::class, 'compareMail'])->name('vehicles.compare-mail');
        $router->get('/recently-added-vehicles', [VehicleController::class, 'recentlyAdded'])
            ->name('vehicles.recentlyAdded');
        $router->any('/featured-vehicles/{vehicle:slug?}', [VehicleController::class, 'featured'])
            ->name('vehicles.featured');
        $router->any('/similar-vehicles/{vehicle:slug}', [VehicleController::class, 'similar'])
            ->name('vehicles.similar');

        $router->any('/promoted-vehicles/{vehicle:slug?}', [VehicleController::class, 'promoted'])
            ->name('vehicles.promoted');

        $router->post('/top-taxonomies', [VehicleController::class, 'topTaxonomies'])->name('top-taxonomies');

        $router->get('/lease-vehicle-actions/{variant:slug}', [LeaseVehicleController::class, 'actions'])->name('lease-vehicles.actions');
        $router->post('/find-lease-vehicle', [FilterController::class, 'leaseVehicleIndex'])->name('lease-vehicles.index');
        $router->get('/featured-lease-vehicles', [LeaseVehicleController::class, 'getFeatured'])->name('lease-vehicles.featured');

        $router->get('/valuations', [ValuationController::class, 'show'])->name('valuations.show');
        $router->post('/valuations', [ValuationController::class, 'get'])->name('valuations.get');
        $router->post('valuations/submit-customer', [ValuationController::class, 'submitCustomerDetails'])
            ->name('valuations.submit-customer');
        $router->get('/dealerships/{dealership:slug}', [DealershipController::class, 'show'])->name('dealerships.show');
        $router->get('/dealerships', [DealershipController::class, 'index'])->name('dealerships.index');

        $router->get('/franchises/{franchise:slug}', [FranchiseController::class, 'show'])->name('franchises.show');
        $router->get('/franchises/{franchise:slug}/offers', [FranchiseController::class, 'offers'])
            ->name('franchises.offers');

        $router->post('/properties/{category:slug}', [PropertyController::class, 'index'])->name('properties.index');
        $router->get('/properties/{category:slug}/{property:slug}', [PropertyController::class, 'show'])
            ->name('properties.show');

        $router->post('/offers', [OfferController::class, 'index'])->name('offers.index');
        $router->post('/offers/{make}', [OfferController::class, 'search'])->name('offers.search');
        $router->get('/offers/{offer:slug}', [OfferController::class, 'show'])->name('offers.show');
        $router->post('/offer-search', [OfferController::class, 'searchWithFilters'])
            ->name('offers.search-with-filters');

        $router->get('/new-cars/configure/view/{uuid}', [ConfiguratorController::class, 'view'])->name('configurator.view');
        $router->get('/new-cars/configure/', [ConfiguratorController::class, 'index'])->name('configurator.index');
        $router->post('/new-cars/configure/{model}', [ConfiguratorController::class, 'show'])->name('configurator.show');
        $router->put('/new-cars/configure/{model:slug}', [ConfiguratorController::class, 'store'])->name('configurator.store');
        $router->get('/leasing/{variant:slug}', [LeaseVehicleController::class, 'show'])->name('lease-vehicles.show');
        $router->post('/leasing/{variant:slug}/finance', [LeaseVehicleFinanceController::class, 'getVehicleVariantFinance'])->name('lease-vehicles.get-finance');
        $router->post('/leasing/bulk-finance', [LeaseVehicleFinanceController::class, 'getBulkVehicleVariantFinance'])->name('lease-vehicles.get-bulk-finance');
        $router->post('/leasing/{variant:slug}/item-bulk-finance', [LeaseVehicleFinanceController::class, 'getBulkItemFinance'])->name('lease-vehicles.item-bulk-finance');

        $router->post('/new-cars/{make?}', [NewCarController::class, 'search'])->name('new-cars.search');
        $router->get('/new-cars/{car:slug}', [NewCarController::class, 'show'])->name('new-cars.show');

        $router->post('/conversion/track', [ConversionController::class, 'store'])->name('conversions.track');

        $router->post('/service-booking/vehicle-lookup', [ServiceBookingController::class, 'vehicleLookup'])
            ->name('bookings.lookup');
        $router->post('/service-booking/set-location', [ServiceBookingController::class, 'setLocation'])
            ->name('bookings.location');
        $router->post('/service-booking/set-package', [ServiceBookingController::class, 'setPackage'])
            ->name('bookings.package');
        $router->post('/service-booking/availability', [ServiceBookingController::class, 'getAvailability'])
            ->name('bookings.availability');
        $router->post('/service-booking/set-time', [ServiceBookingController::class, 'setAvailability'])
            ->name('bookings.set-availability');
        $router->post('/service-booking/set-delivery', [ServiceBookingController::class, 'setDelivery'])
            ->name('bookings.delivery');
        $router->post('/service-booking/book', [ServiceBookingController::class, 'store'])->name('bookings.book');

        $router->post('reservations/{vehicle:slug}', [ReservationFlowController::class, 'create']);
        $router->put('reservations/{reservation:id}', [ReservationFlowController::class, 'update']);

        $router->any('/checkout/stripe/request', [ StripeController::class, 'index' ]);
        $router->post('/checkout/stripe/set-address', [ StripePaymentRequestController::class, 'setShippingAddress' ]);
        $router->post('/checkout/stripe/prepare-order', [ StripePaymentRequestController::class, 'prepareOrder' ]);
        $router->post('/checkout/stripe/confirm-order', [ StripePaymentRequestController::class, 'confirmOrder' ]);

        $router->post('/integrations/get-token', [IntegrationController::class, 'getToken'])
            ->name('integrations.get-token');

        Route::middleware(['enabled-feature:build-a-deal'])->group(function (Router $router) {
            $router->get('/deal-builder', [DealBuilderController::class, 'show'])
                ->name('deal-builder.show');
            $router->post('/deal-builder/start', [DealBuilderController::class, 'start'])
                ->name('deal-builder.start');
            $router->post('/deal-builder/resume', [DealBuilderController::class, 'resume'])
                ->name('deal-builder.resume');
            $router->post('/deal-builder/add-add-on', [DealBuilderController::class, 'addAddOn'])
                ->name('deal-builder.add-add-on');
            $router->post('/deal-builder/remove-add-on', [DealBuilderController::class, 'removeAddOn'])
                ->name('deal-builder.remove-add-on');
            $router->post('/deal-builder/add-part-exchange', [DealBuilderController::class, 'addPartExchange'])
                ->name('deal-builder.add-part-exchange');
            $router->post('/deal-builder/part-exchange-lookup', [DealBuilderController::class, 'lookupPartExchangeVehicle'])
                ->name('deal-builder.vehicle-lookup');
            $router->post('/deal-builder/remove-part-exchange', [DealBuilderController::class, 'removePartExchange'])
                ->name('deal-builder.remove-part-exchange');
            $router->post('/deal-builder/update-part-exchange', [DealBuilderController::class, 'updatePartExchange'])
                ->name('deal-builder.update-part-exchange');
            $router->post('/deal-builder/set-finance-terms', [DealBuilderController::class, 'setFinanceTerms'])
                ->name('deal-builder.set-finance-terms');
            $router->post('/deal-builder/select-finance-quote', [DealBuilderController::class, 'selectFinanceQuote'])
                ->name('deal-builder.select-finance-quote');
            $router->post('/deal-builder/set-payment-type', [DealBuilderController::class, 'setPaymentType'])
                ->name('deal-builder.set-payment-type');
            $router->post('/deal-builder/initiate-payment', [DealBuilderController::class, 'initiatePayment'])
                ->name('deal-builder.initiate-payment');
            $router->post('/deal-builder/submit-deal', [DealBuilderController::class, 'submitDeal'])
                ->name('deal-builder.submit-deal');
            $router->get('/deal-builder/verify/{reference}', [DealBuilderController::class, 'verify'])
                ->name('deal-builder.verify');
        });

        $router->any('/checkout/stripe/request', [StripeController::class, 'index']);
        $router->post('/checkout/stripe/set-address', [StripePaymentRequestController::class, 'setShippingAddress']);
        $router->post('/checkout/stripe/prepare-order', [StripePaymentRequestController::class, 'prepareOrder']);
        $router->post('/checkout/stripe/confirm-order', [StripePaymentRequestController::class, 'confirmOrder']);
    });
});
