<?php

namespace Tests\Unit\Rules;

use App\Rules\CashbackDoesNotExceedValuation;
use Tests\TestCase;

class CashbackDoesNotExceedValuationTest extends TestCase
{
    public function test_zero_cashback_always_passes(): void
    {
        $rule = new CashbackDoesNotExceedValuation(10000, 3000);
        $failed = false;

        $rule->validate('cashback_amount', 0, function () use (&$failed) {
            $failed = true;
        });

        $this->assertFalse($failed);
    }

    public function test_cashback_within_limit_passes(): void
    {
        // Retail: 10000, Finance: 3000, Max cashback: 7000
        $rule = new CashbackDoesNotExceedValuation(10000, 3000);
        $failed = false;

        $rule->validate('cashback_amount', 5000, function () use (&$failed) {
            $failed = true;
        });

        $this->assertFalse($failed);
    }

    public function test_cashback_at_exact_limit_passes(): void
    {
        // Retail: 10000, Finance: 3000, Max cashback: 7000
        $rule = new CashbackDoesNotExceedValuation(10000, 3000);
        $failed = false;

        $rule->validate('cashback_amount', 7000, function () use (&$failed) {
            $failed = true;
        });

        $this->assertFalse($failed);
    }

    public function test_cashback_exceeding_limit_fails(): void
    {
        // Retail: 10000, Finance: 3000, Max cashback: 7000
        $rule = new CashbackDoesNotExceedValuation(10000, 3000);
        $failed = false;

        $rule->validate('cashback_amount', 8000, function () use (&$failed) {
            $failed = true;
        });

        $this->assertTrue($failed);
    }

    public function test_cashback_with_no_outstanding_finance(): void
    {
        // Retail: 15000, Finance: 0, Max cashback: 15000
        $rule = new CashbackDoesNotExceedValuation(15000, 0);
        $failed = false;

        $rule->validate('cashback_amount', 15000, function () use (&$failed) {
            $failed = true;
        });

        $this->assertFalse($failed);
    }

    public function test_cashback_fails_when_finance_exceeds_valuation(): void
    {
        // Retail: 5000, Finance: 8000, Max cashback: -3000 (negative)
        $rule = new CashbackDoesNotExceedValuation(5000, 8000);
        $failed = false;

        $rule->validate('cashback_amount', 1, function () use (&$failed) {
            $failed = true;
        });

        // Any positive cashback should fail when max is negative
        $this->assertTrue($failed);
    }
}
