<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Http\Resources\LiveChatResource;
use App\Http\Resources\MakeListResource;
use App\Http\Resources\MenuResource;
use App\Http\Resources\OfferListResource;
use App\Http\Resources\PageListResource;
use App\Http\Resources\PhoneNumberDisplay;
use App\Http\Resources\SiteResource;
use App\Http\Resources\UiBrands;
use App\Http\Resources\UiResponsiveProductList;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\DB;
use Mtc\ContentManager\Models\ContentElementField;
use Mtc\Crm\Models\Form;
use Mtc\Crm\Models\FormQuestion;
use Mtc\Crm\Models\FormSection;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\GlobalContent;
use Mtc\MercuryDataModels\Menu;
use Mtc\MercuryDataModels\MenuEntry;
use Mtc\MercuryDataModels\OfferType;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TenantTestCase;
use Tests\TestCase;

class ResponsiveProductListTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testUiResponsiveProductList()
    {
        Vehicle::factory(5)->create(['is_published' => true, 'featured' => 1]);
        $resource = (new UiResponsiveProductList((object)['name' => 'foo baz bar']))->toArray(request());
        $this->assertEquals('foo baz bar', $resource['name']);
        $this->assertArrayHasKey('items', $resource);
        $this->assertCount(4, $resource['items']);
    }
}
