<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class MicrosoftClarityTracker implements Arrayable
{
    public function toArray()
    {
        $code = Settings::get('tracking-microsoft-clarity-project-id');
        return [
            [
                "body" => '(function(c,l,a,r,i,t,y){'
                    . '  c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};'
                    . '  t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;'
                    . '  y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);'
                    . '})(window, document, "clarity", "script", "' . $code . '");'
                    . 'var noscript = document.createElement("noscript");'
                    . 'var img = document.createElement("img");'
                    . 'img.setAttribute("height", "1");'
                    . 'img.setAttribute("width", "1");'
                    . 'img.setAttribute("style", "display:none;");'
                    . 'img.setAttribute("alt", "");'
                    . 'img.setAttribute("src", "'
                    . 'https://www.clarity.ms/tag/collect?project=' . $code . '&event=pageview");'
                    . 'noscript.appendChild(img);'
                    . 'document.body.appendChild(noscript);',
                'data-consent' => 'marketing'
            ]
        ];
    }
}
