<?php

namespace Tests;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Mtc\VehicleValuation\Models\VehicleValuation;
use Mtc\VehicleValuation\ValuationRepository;

class TestValuationRepository extends ValuationRepository
{
    public function get(string $registration, int $mileage, ?string $variant = null)
    {
        return VehicleValuation::query()->create([
            'user_id' => Auth::id(),
            'provider' => 'fake',
            'registration' => $registration,
            'mileage' => $mileage,
            'vehicle_type' => 'car',
            'make' => 'foo',
            'model' => 'baz',
            'derivative' => 'foo baz bar',
            'fuel_type' => 'petrol',
            'engine_size' => 2000,
            'body_type' => 'coupe',
            'transmission' => 'automatic',
            'date_of_registration' => Carbon::now(),
            'valuation_made_at' => Carbon::now(),
            'retail_price' => random_int(1000, 40000),
            'average_price' => random_int(1000, 40000),
            'clean_price' => random_int(1000, 40000),
            'below_price' => random_int(1000, 40000),
            'errors' => null,
        ]);
    }
}
