<?php

namespace Tests\Data;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\MercuryDataModels\GlobalContent;

class GlobalContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        GlobalContent::query()->truncate();
        collect($this->getList())
            ->each(fn ($entry) => GlobalContent::query()->create($entry));
    }

    private function getList()
    {
        return [
            [
                'name' => 'Featured vehicles',
                'slug' => 'featured-vehicles',
                'ui_component' => 'UiResponsiveProductList',
                'element_id' => ContentElement::query()->where('slug', 'featured-vehicles')->first()?->id,
            ],
        ];
    }
}
