<?php

namespace App\Filter\Sorting;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\App;
use Mtc\Filter\Contracts\IsSortOption;

class MonthlyPriceAscending implements IsSortOption
{
    /**
     * Perform sorting query adjustments
     *
     * @param Builder $query
     * @return Builder
     */
    public function handle(Builder $query): Builder
    {
        if (App::runningUnitTests()) {
            return $query->orderBy('monthly_price');
        } else {
            return $query->orderByRaw('CASE WHEN `monthly_price` is null then 1 else 0 end')
                ->orderBy('monthly_price');
        }
    }
}
