<?php

namespace App\Http\Resources;

use App\Traits\MapElementBasedContent;
use Illuminate\Http\Resources\Json\JsonResource;

class GlobalContentResource extends JsonResource
{
    use MapElementBasedContent;

    public static $wrap = '';

    public function toArray($request): array
    {
        $this->resource->load('mediaUses.media');
        return collect($this->resource->content)
            ->map(fn($entry) => $this->mapContent($this->resource, $entry ?? [], $request, 'global-content'))
            ->toArray();
    }
}
