<?php

namespace App\Http\Controllers;

use App\Http\Requests\VehicleContentReviewsRequest;
use App\Http\Requests\VehicleContentVideosRequest;
use App\Http\Resources\VehicleContentCollection;
use App\Services\VehicleContentService;
use App\Traits\CacheObject;

class VehicleContentController extends Controller
{
    use CacheObject;

    public function __construct(
        private VehicleContentService $service
    ) {
    }

    public function videos(VehicleContentVideosRequest $request): array
    {
        $makeId = $request->input('make_id');
        $modelId = $request->input('model_id');
        $perPage = $request->input('per_page');
        $page = $request->input('page', 1);

        $cacheKey = 'vehicle-content-videos-' . md5(json_encode([
            'make_id' => $makeId,
            'model_id' => $modelId,
            'per_page' => $perPage,
            'page' => $page,
        ]));

        return $this->cache($cacheKey, 5, function () use ($makeId, $modelId, $perPage, $page) {
            $videos = $this->service->getVideos($makeId, $modelId, $perPage, $page);

            return (new VehicleContentCollection($videos, 'videos'))->toArray(request());
        });
    }

    public function reviews(VehicleContentReviewsRequest $request): array
    {
        $provider = $request->input('provider');
        $makeId = $request->input('make_id');
        $modelId = $request->input('model_id');
        $perPage = $request->input('per_page');
        $page = $request->input('page', 1);

        $cacheKey = 'vehicle-content-reviews-' . md5(json_encode([
            'provider' => $provider,
            'make_id' => $makeId,
            'model_id' => $modelId,
            'per_page' => $perPage,
            'page' => $page,
        ]));

        return $this->cache($cacheKey, 5, function () use ($provider, $makeId, $modelId, $perPage, $page) {
            $reviews = $this->service->getReviews($provider, $makeId, $modelId, $perPage, $page);

            return (new VehicleContentCollection($reviews, 'reviews'))->toArray(request());
        });
    }
}
