<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Sales\SilverBullet;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class SilverBulletTest extends TenantTestCase
{
    public function testVehicleAction()
    {
        $vehicle = Vehicle::factory()->create();
        /** @var SilverBullet $service */
        $service = App::make(SilverBullet::class);

        $widget = $service->getVehicleAction($vehicle, 'finance');
        $this->assertIsArray($widget);
        $this->assertArrayHasKey('type', $widget);
        $this->assertArrayHasKey('value', $widget);
        $this->assertArrayHasKey('data', $widget);
        $this->assertArrayHasKey('url', $widget['data']);
    }

    public function testUrl()
    {
        $vehicle = Vehicle::factory()->create();
        /** @var SilverBullet $service */
        $service = App::make(SilverBullet::class);

        $widget = $service->getVehicleAction($vehicle, 'finance');
        $this->assertStringContainsString('/start-finance/', $widget['data']['url']);
        $widget = $service->getVehicleAction($vehicle, 'valuation');
        $this->assertStringContainsString('/start-trade-in/', $widget['data']['url']);
        $widget = $service->getVehicleAction($vehicle, 'sale');
        $this->assertStringContainsString('/start/', $widget['data']['url']);
    }

    public function testReserveCost()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Sales',
            'group' => 'Keyloop Ecommerce',
            'name' => 'Reserve button text',
            'config_key' => 'sales-silver-bullet-reserve-button-text',
            'type' => 'string',
            'value' => 'Reserve for :amount',
            'description' => 'Add :amount value to allow per-dealership costs',
            'order' => 15,
        ]);
        $dealership = Dealership::factory()->create([
            'data' => [
                'silver-bullet-reserve-cost' => 199
            ]
        ]);
        $vehicle = Vehicle::factory()->create(['dealership_id' => $dealership->id]);
        /** @var SilverBullet $service */
        $service = App::make(SilverBullet::class);
        $widget = $service->getVehicleAction($vehicle, 'reserve');
        $this->assertStringContainsString('199', $widget['data']['title']);
    }
}
