<?php

namespace Tests\Unit;

use App\LocalisationService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Country;
use Tests\TenantTestCase;
use Tests\TestCase;

class LocalisationServiceTest extends TestCase
{
    use RefreshDatabase;
    protected function setUp(): void
    {
        parent::setUp();
        Country::unguard();
    }

    public function testPhonePrefixReturnsDialCodeWithPlus(): void
    {
        Country::query()->create([
            'name' => 'United Kingdom',
            'code' => 'GB',
            'dial_code' => '44',
            'has_postcodes' => true,
        ]);

        $result = (new LocalisationService())->phonePrefix('GB');

        $this->assertEquals('+44', $result);
    }

    public function testPhonePrefixReturnsEmptyStringForNullCountryCode(): void
    {
        $result = (new LocalisationService())->phonePrefix(null);

        $this->assertEquals('', $result);
    }

    public function testPhonePrefixReturnsEmptyStringForEmptyCountryCode(): void
    {
        $result = (new LocalisationService())->phonePrefix('');

        $this->assertEquals('', $result);
    }

    public function testPhonePrefixReturnsEmptyPrefixForNonExistentCountry(): void
    {
        $result = (new LocalisationService())->phonePrefix('XX');

        $this->assertEquals('+', $result);
    }

    public function testPhonePrefixReturnsCorrectDialCodeForDifferentCountries(): void
    {
        Country::query()->create([
            'name' => 'United States',
            'code' => 'US',
            'dial_code' => '1',
            'has_postcodes' => true,
        ]);

        Country::query()->create([
            'name' => 'Germany',
            'code' => 'DE',
            'dial_code' => '49',
            'has_postcodes' => true,
        ]);

        $this->assertEquals('+1', (new LocalisationService())->phonePrefix('US'));
        $this->assertEquals('+49', (new LocalisationService())->phonePrefix('DE'));
    }
}
