<?php

declare(strict_types=1);

namespace App\Middleware;

use Closure;

class InitializeTenancyByDomain extends \Stancl\Tenancy\Middleware\InitializeTenancyByDomain
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    #[\Override]
    public function handle($request, Closure $next)
    {
        self::$onFail = fn($e) => response($request->header('x-tenant') . ' Not Found', 404);

        return $this->initializeTenancy(
            $request,
            $next,
            $request->header('x-tenant')
        );
    }
}
