<?php

declare(strict_types=1);

use App\Http\Controllers\StatsController;
use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use App\Http\Middleware\SeoRedirectCheckMiddleware;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Stancl\Tenancy\Middleware\InitializeTenancyByRequestData;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'api',
    InitializeTenancyByRequestData::class,
    PreventRequestsIfTenantSuspended::class,
])->group(function (Router $router) {
    $router->post('graph', [StatsController::class, 'graph'])->name('view-graph');
});
