<?php

namespace Tests;

use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use App\Tier;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\Tenant;
use Stancl\Tenancy\Middleware\InitializeTenancyByRequestData;

abstract class TenantTestCase extends TestCase
{
    use DispatchesJobs;

    protected Tenant $tenant;

    protected function setUp(): void
    {
        parent::setUp();

        // Bind test repositories
        $this->app->singleton('site-settings', TestSettingRepository::class);
        $this->app->singleton('feature-flags', TestFeatureRepository::class);

        $this->tenant = $this->createTestTenant();

        $this->withoutMiddleware([
            InitializeTenancyByRequestData::class,
            PreventRequestsIfTenantSuspended::class,
        ]);

        tenancy()->initialize($this->tenant);
        Config::set('database.default', 'sqlite');
    }

    protected function createTestTenant(): Tenant
    {
        $tenant = new Tenant([
            'tier' => Tier::ENTERPRISE->value,
            'name' => 'Test Tenant',
        ]);
        $tenant->id = 'test-tenant';
        $tenant->matomo_site_id = 123;

        $tenant->features = collect([
            (object)['feature' => 'reservations'],
            (object)['feature' => 'service-booking'],
        ]);

        $tenant->primaryDomain = (object)[
            'domain' => 'test.localhost'
        ];

        return $tenant;
    }

    protected function asTenant($tenant = null)
    {
        $tenant = $tenant ?? $this->tenant;
        return $this->withHeader('X-Tenant', $tenant->primaryDomain->domain);
    }
}
