<?php

namespace Tests;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Tenant;

class TestFeatureRepository
{
    private array $enabledFeatures = [];

    public function __construct()
    {
        $this->enabledFeatures = [
            'reservations' => true,
            'service-booking' => true,
        ];
    }

    public function isEnabled(string $feature): bool
    {
        return $this->enabledFeatures[$feature] ?? false;
    }

    public function setEnabled(string $feature, bool $enabled = true): void
    {
        $this->enabledFeatures[$feature] = $enabled;
    }

    public function getAll(): Collection
    {
        return collect($this->enabledFeatures);
    }

    public function enabledForTenant(): Collection
    {
        return collect($this->enabledFeatures)->filter();
    }
}
