<?php

namespace Tests;

class TestSettingRepository
{
    private array $settings = [];

    public function __construct()
    {
        $this->settings = [
            'app-primary-colour' => '#3498db',
            'app-secondary-colour' => '#2ecc71',
            'app-tertiary-colour' => '#9b59b6',
            'app-success-colour' => '#27ae60',
            'app-error-colour' => '#e74c3c',
            'app-information-colour' => '#3498db',
            'app-text-colour' => '#2c3e50',
            'app-subtext-colour' => '#7f8c8d',
            'app-layer-dark-colour' => '#34495e',
            'app-layer-accent-colour' => '#1abc9c',
            'app-layer-light-colour' => '#ecf0f1',
        ];
    }

    public function get(string $key, $default = null)
    {
        return $this->settings[$key] ?? $default;
    }

    public function set(string $key, $value): void
    {
        $this->settings[$key] = $value;
    }

    public function make(array $setting)
    {
        $this->settings[$setting['config_key']] = $setting['value'] ?? null;
        return (object) $setting;
    }

    public function update(string $key, $value): void
    {
        $this->settings[$key] = $value;
    }
}
