<?php

namespace App\Metrics;

use Illuminate\Support\Facades\DB;
use Mtc\MercuryDataModels\Booking;
use Spatie\Analytics\Period;

class ServiceBookingCount
{
    public function get(Period $period)
    {
        return Booking::query()
            ->select(DB::raw('count(*) as count'), DB::raw('DATE(ingested_at) as date'))
            ->where('ingested_at', '>=', $period->startDate->format('Y-m-d'))
            ->where('ingested_at', '<=', $period->endDate->format('Y-m-d 23:59:59'))
            ->whereNotNull('ingested_at')
            ->groupBy('date')
            ->get()
            ->pluck('count', 'date');
    }
}
