<div class="flex h-full w-full flex-1 flex-col gap-6 rounded-xl">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-zinc-900 dark:text-white">Shipping Rules</h2>
            <p class="text-sm text-zinc-500 dark:text-zinc-400">Define conditions to filter shipping rates based on cart contents</p>
        </div>
        <a href="{{ route('bigcommerce.rules.create', ['storeHash' => $storeHash]) }}"
           class="inline-flex items-center gap-2 bg-blue-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-blue-700 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
            </svg>
            Add Rule
        </a>
    </div>

    <!-- Rules List -->
    <div class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Active Rules</h3>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400">Rules are evaluated in priority order (lowest number first)</p>
                </div>
                <span class="text-xs text-zinc-500 dark:text-zinc-400">Drag to reorder priorities</span>
            </div>
        </div>

        <div class="p-6">
            @if($rules->count() > 0)
                <div
                    x-data="{
                        items: @js($rules->pluck('id')->toArray()),
                        dragging: null,
                        dragOver: null
                    }"
                    class="space-y-3"
                >
                    @foreach($rules as $rule)
                        <div
                            draggable="true"
                            x-on:dragstart="dragging = {{ $rule->id }}"
                            x-on:dragend="dragging = null; dragOver = null"
                            x-on:dragover.prevent="dragOver = {{ $rule->id }}"
                            x-on:drop.prevent="
                                if (dragging !== {{ $rule->id }}) {
                                    let fromIndex = items.indexOf(dragging);
                                    let toIndex = items.indexOf({{ $rule->id }});
                                    items.splice(fromIndex, 1);
                                    items.splice(toIndex, 0, dragging);
                                    $wire.updatePriorities(items);
                                }
                                dragging = null;
                                dragOver = null;
                            "
                            :class="{
                                'ring-2 ring-blue-500 ring-offset-2 dark:ring-offset-zinc-900': dragOver === {{ $rule->id }} && dragging !== {{ $rule->id }},
                                'opacity-50': dragging === {{ $rule->id }}
                            }"
                            class="bg-zinc-50 dark:bg-zinc-800 border border-zinc-200 dark:border-zinc-700 rounded-lg p-4 transition-all cursor-move"
                        >
                            <div class="flex items-center gap-4">
                                <!-- Drag Handle -->
                                <div class="flex-shrink-0 text-zinc-400 dark:text-zinc-500 cursor-grab active:cursor-grabbing">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
                                    </svg>
                                </div>

                                <!-- Priority Badge -->
                                <div class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-600 text-white flex items-center justify-center text-sm font-bold">
                                    {{ $rule->priority }}
                                </div>

                                <!-- Rule Info -->
                                <div class="flex-1 min-w-0">
                                    <div class="flex items-center gap-2">
                                        <h4 class="font-semibold text-zinc-900 dark:text-white truncate">{{ $rule->name }}</h4>
                                        @if(!$rule->enabled)
                                            <span class="text-xs bg-zinc-200 dark:bg-zinc-700 text-zinc-600 dark:text-zinc-400 px-2 py-0.5 rounded">Disabled</span>
                                        @endif
                                    </div>
                                    @if($rule->description)
                                        <p class="text-sm text-zinc-500 dark:text-zinc-400 truncate">{{ $rule->description }}</p>
                                    @endif
                                    <div class="flex items-center gap-4 mt-2 text-xs text-zinc-500 dark:text-zinc-400">
                                        <span class="flex items-center gap-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-3.5 h-3.5">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z" />
                                            </svg>
                                            {{ $rule->conditions->count() }} condition{{ $rule->conditions->count() !== 1 ? 's' : '' }}
                                        </span>
                                        <span class="flex items-center gap-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-3.5 h-3.5">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z" />
                                            </svg>
                                            {{ $rule->actions->count() }} action{{ $rule->actions->count() !== 1 ? 's' : '' }}
                                        </span>
                                        <span class="capitalize">Match: {{ $rule->match_type }}</span>
                                    </div>
                                </div>

                                <!-- Enable Toggle -->
                                <div class="flex-shrink-0">
                                    <button
                                        wire:click="toggleEnabled({{ $rule->id }})"
                                        class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors cursor-pointer {{ $rule->enabled ? 'bg-blue-600' : 'bg-zinc-300 dark:bg-zinc-600' }}"
                                    >
                                        <span class="sr-only">Toggle rule</span>
                                        <span
                                            class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $rule->enabled ? 'translate-x-6' : 'translate-x-1' }}"
                                        ></span>
                                    </button>
                                </div>

                                <!-- Actions -->
                                <div class="flex-shrink-0 flex items-center gap-2">
                                    <a href="{{ route('bigcommerce.rules.edit', ['storeHash' => $storeHash, 'rule' => $rule->id]) }}"
                                       class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 p-1.5 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition-colors"
                                       title="Edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" />
                                        </svg>
                                    </a>
                                    <button
                                        wire:click="duplicateRule({{ $rule->id }})"
                                        class="text-zinc-600 dark:text-zinc-400 hover:text-zinc-700 dark:hover:text-zinc-300 p-1.5 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition-colors cursor-pointer"
                                        title="Duplicate">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 01-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 011.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 00-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 01-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 00-3.375-3.375h-1.5a1.125 1.125 0 01-1.125-1.125v-1.5a3.375 3.375 0 00-3.375-3.375H9.75" />
                                        </svg>
                                    </button>
                                    <button
                                        wire:click="confirmDelete({{ $rule->id }})"
                                        class="text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 p-1.5 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition-colors cursor-pointer"
                                        title="Delete">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0" />
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <!-- Conditions Preview -->
                            @if($rule->conditions->count() > 0)
                                <div class="mt-3 pt-3 border-t border-zinc-200 dark:border-zinc-700">
                                    <div class="flex flex-wrap gap-2">
                                        @foreach($rule->conditions->take(3) as $condition)
                                            <span class="inline-flex items-center gap-1 text-xs bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300 px-2 py-1 rounded">
                                                <span class="font-medium">{{ ucfirst($condition->field_source) }}:</span>
                                                {{ $condition->field_name }}
                                                <span class="text-zinc-500 dark:text-zinc-400">{{ $condition->field_operator }}</span>
                                                "{{ Str::limit($condition->field_value, 15) }}"
                                            </span>
                                        @endforeach
                                        @if($rule->conditions->count() > 3)
                                            <span class="text-xs text-zinc-500 dark:text-zinc-400">+{{ $rule->conditions->count() - 3 }} more</span>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            <!-- Actions Preview -->
                            @if($rule->actions->count() > 0)
                                <div class="mt-2">
                                    <div class="flex flex-wrap gap-2">
                                        @foreach($rule->actions as $action)
                                            <span class="inline-flex items-center gap-1 text-xs px-2 py-1 rounded {{ $action->action_type === 'include' ? 'bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-400' : 'bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-400' }}">
                                                {{ $action->action_type === 'include' ? '+' : '-' }}
                                                {{ $action->pattern_operator }}:
                                                "{{ $action->rate_pattern }}"
                                            </span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-12 h-12 text-zinc-300 dark:text-zinc-600 mx-auto mb-3">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 12h16.5m-16.5 3.75h16.5M3.75 19.5h16.5M5.625 4.5h12.75a1.875 1.875 0 010 3.75H5.625a1.875 1.875 0 010-3.75z" />
                    </svg>
                    <p class="text-sm font-medium text-zinc-900 dark:text-white">No shipping rules yet</p>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400 mt-1">Create your first rule to start filtering shipping rates</p>
                    <a href="{{ route('bigcommerce.rules.create', ['storeHash' => $storeHash]) }}"
                       class="inline-flex items-center gap-2 mt-4 bg-blue-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-blue-700 transition-colors">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                        </svg>
                        Create First Rule
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    @if($showDeleteModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm p-4">
            <div class="bg-white dark:bg-zinc-900 rounded-xl shadow-xl max-w-md w-full border border-zinc-200 dark:border-zinc-700">
                <div class="p-6">
                    <div class="flex items-center justify-center w-12 h-12 mx-auto bg-red-100 dark:bg-red-900/30 rounded-full mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-6 h-6 text-red-600 dark:text-red-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-zinc-900 dark:text-white text-center mb-2">Delete Rule</h3>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400 text-center">Are you sure you want to delete this rule? This action cannot be undone.</p>
                </div>
                <div class="flex items-center justify-end gap-3 px-6 py-4 border-t border-zinc-200 dark:border-zinc-700">
                    <button
                        wire:click="cancelDelete"
                        class="px-4 py-2 text-sm font-medium text-zinc-700 dark:text-zinc-300 bg-zinc-100 dark:bg-zinc-800 rounded-lg hover:bg-zinc-200 dark:hover:bg-zinc-700 transition-colors cursor-pointer"
                    >
                        Cancel
                    </button>
                    <button
                        wire:click="deleteRule"
                        class="px-4 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700 transition-colors cursor-pointer"
                    >
                        Delete
                    </button>
                </div>
            </div>
        </div>
    @endif
</div>
