<div x-data="{ open: @entangle('showDrawer') }"
     x-show="open"
     x-cloak
     class="fixed inset-0 z-50 flex justify-end">

    {{-- Overlay --}}
    <div class="fixed inset-0 bg-black/50 dark:bg-black/70" @click="open = false; $wire.closeDrawer()"></div>

    {{-- Drawer --}}
    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="translate-x-full"
        x-transition:enter-end="translate-x-0"
        x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="translate-x-0"
        x-transition:leave-end="translate-x-full"
        class="relative w-full max-w-md h-full bg-white dark:bg-zinc-900 text-zinc-900 dark:text-white shadow-xl overflow-hidden flex flex-col border-l border-zinc-200 dark:border-zinc-700">

        {{-- Header --}}
        <div class="flex items-center justify-between px-6 py-4 border-b border-zinc-200 dark:border-zinc-700 flex-shrink-0">
            <h2 class="text-xl font-bold text-zinc-900 dark:text-white">Attach Products to Rate</h2>
            <button @click="open = false; $wire.closeDrawer()"
                    class="rounded-lg p-2 text-zinc-500 hover:bg-zinc-100 dark:hover:bg-zinc-800 hover:text-zinc-700 dark:hover:text-zinc-300 transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>

        {{-- Content --}}
        <div class="flex-1 overflow-y-auto p-6 space-y-6">
            {{-- Search --}}
            <div class="flex gap-2">
                <select wire:model="filterBy"
                        class="border border-zinc-300 dark:border-zinc-600 rounded-lg px-3 py-2 text-sm bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="name">Name</option>
                    <option value="sku">SKU</option>
                    <option value="product_id">Product ID</option>
                </select>
                <input type="text"
                       wire:model.debounce.500ms="search"
                       placeholder="Search..."
                       class="flex-1 border border-zinc-300 dark:border-zinc-600 rounded-lg px-3 py-2 text-sm bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white placeholder-zinc-400 dark:placeholder-zinc-500 focus:ring-2 focus:ring-blue-500 focus:border-blue-500" />
            </div>

            {{-- Available Products --}}
            <div>
                <h3 class="text-sm font-semibold text-zinc-900 dark:text-white mb-3 flex items-center gap-2">
                    <div class="rounded-full bg-blue-100 p-1.5 dark:bg-blue-900/30">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-blue-600 dark:text-blue-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M20.25 7.5l-.625 10.632a2.25 2.25 0 01-2.247 2.118H6.622a2.25 2.25 0 01-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125z" />
                        </svg>
                    </div>
                    Available Products
                </h3>
                <ul class="space-y-2">
                    @forelse($products as $product)
                        <li class="flex items-center justify-between p-3 rounded-lg border border-zinc-200 dark:border-zinc-700 bg-zinc-50 dark:bg-zinc-800/50 hover:bg-zinc-100 dark:hover:bg-zinc-800 transition-colors">
                            <div class="min-w-0 flex-1">
                                <div class="font-medium text-zinc-900 dark:text-white truncate">{{ $product->name }}</div>
                                <div class="text-xs text-zinc-500 dark:text-zinc-400">
                                    SKU: {{ $product->sku ?: '-' }} | ID: {{ $product->product_id }}
                                </div>
                            </div>
                            <button wire:click="attachProduct({{ $product->id }})"
                                    class="ml-3 inline-flex items-center gap-1 px-3 py-1.5 text-xs font-medium text-blue-600 dark:text-blue-400 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg hover:bg-blue-100 dark:hover:bg-blue-900/40 transition-colors flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                                </svg>
                                Attach
                            </button>
                        </li>
                    @empty
                        <li class="flex flex-col items-center py-8 text-center">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-zinc-300 dark:text-zinc-600 mb-2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                            </svg>
                            <p class="text-sm text-zinc-500 dark:text-zinc-400">No products found.</p>
                        </li>
                    @endforelse
                </ul>
                <div class="mt-3">{{ $products->links() }}</div>
            </div>

            {{-- Attached Products --}}
            <div>
                <h3 class="text-sm font-semibold text-zinc-900 dark:text-white mb-3 flex items-center gap-2">
                    <div class="rounded-full bg-green-100 p-1.5 dark:bg-green-900/30">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-green-600 dark:text-green-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    Attached Products
                </h3>
                <ul class="space-y-2">
                    @forelse($attachedProducts as $product)
                        <li class="flex items-center justify-between p-3 rounded-lg border border-green-200 dark:border-green-800/50 bg-green-50 dark:bg-green-900/20 hover:bg-green-100 dark:hover:bg-green-900/30 transition-colors">
                            <div class="min-w-0 flex-1">
                                <div class="font-medium text-zinc-900 dark:text-white truncate">{{ $product->name }}</div>
                                <div class="text-xs text-zinc-500 dark:text-zinc-400">
                                    SKU: {{ $product->sku ?: '-' }} | ID: {{ $product->product_id }}
                                </div>
                            </div>
                            <button wire:click="detachProduct({{ $product->id }})"
                                    class="ml-3 inline-flex items-center gap-1 px-3 py-1.5 text-xs font-medium text-red-600 dark:text-red-400 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg hover:bg-red-100 dark:hover:bg-red-900/40 transition-colors flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                                Remove
                            </button>
                        </li>
                    @empty
                        <li class="flex flex-col items-center py-8 text-center">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-zinc-300 dark:text-zinc-600 mb-2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M20.25 7.5l-.625 10.632a2.25 2.25 0 01-2.247 2.118H6.622a2.25 2.25 0 01-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125z" />
                            </svg>
                            <p class="text-sm text-zinc-500 dark:text-zinc-400">No products attached.</p>
                        </li>
                    @endforelse
                </ul>
                <div class="mt-3">{{ $attachedProducts->links('pagination::tailwind') }}</div>
            </div>
        </div>
    </div>
</div>
