<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('product_rates')) {
            Schema::create('product_rates', function (Blueprint $table) {
                $table->id();
                $table->bigInteger("rate_details_id");
                $table->bigInteger("store_product_id");
                $table->timestamps();
                $table->unique(['rate_details_id', 'store_product_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_rates');
    }
};
