<div class="flex h-full w-full flex-1 flex-col gap-6 rounded-xl">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div class="flex items-center gap-4">
            <a href="{{ route('bigcommerce.rules.index', ['storeHash' => $storeHash]) }}"
               class="text-zinc-500 dark:text-zinc-400 hover:text-zinc-700 dark:hover:text-zinc-200 transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-6 h-6">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5L3 12m0 0l7.5-7.5M3 12h18" />
                </svg>
            </a>
            <div>
                <h2 class="text-2xl font-bold text-zinc-900 dark:text-white">
                    {{ $isEditing ? 'Edit Rule' : 'Create Rule' }}
                </h2>
                <p class="text-sm text-zinc-500 dark:text-zinc-400">Define conditions and actions for shipping rate filtering</p>
            </div>
        </div>
        <div class="flex items-center gap-3">
            <button wire:click="cancel" class="px-4 py-2 text-sm font-medium text-zinc-700 dark:text-zinc-300 bg-zinc-100 dark:bg-zinc-800 rounded-lg hover:bg-zinc-200 dark:hover:bg-zinc-700 transition-colors cursor-pointer">
                Cancel
            </button>
            <button wire:click="save" class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 transition-colors cursor-pointer">
                {{ $isEditing ? 'Update Rule' : 'Save Rule' }}
            </button>
        </div>
    </div>

    <!-- Basic Info Section -->
    <div class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Basic Information</h3>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">Rule Name</label>
                    <input type="text" wire:model="name"
                           class="w-full px-3 py-2 border border-zinc-300 dark:border-zinc-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white"
                           placeholder="e.g., Free Sample Shipping">
                    @error('name') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">Priority</label>
                    <input type="number" wire:model="priority" min="0"
                           class="w-full px-3 py-2 border border-zinc-300 dark:border-zinc-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white">
                    @error('priority') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>
                <div class="flex items-end">
                    <label class="flex items-center gap-2 cursor-pointer">
                        <input type="checkbox" wire:model="enabled"
                               class="w-4 h-4 text-blue-600 border-zinc-300 dark:border-zinc-600 rounded focus:ring-blue-500 bg-white dark:bg-zinc-800">
                        <span class="text-sm font-medium text-zinc-700 dark:text-zinc-300">Enabled</span>
                    </label>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">Description (optional)</label>
                    <input type="text" wire:model="description"
                           class="w-full px-3 py-2 border border-zinc-300 dark:border-zinc-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white"
                           placeholder="Brief description of what this rule does">
                </div>
                <div>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">Match Type</label>
                    <select wire:model="match_type"
                            class="w-full px-3 py-2 border border-zinc-300 dark:border-zinc-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white">
                        <option value="all">ALL items must match</option>
                        <option value="any">ANY item must match</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Conditions Section -->
    <div class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">WHEN (Conditions)</h3>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400">Define when this rule should apply</p>
                </div>
                <button wire:click="addConditionGroup"
                        class="inline-flex items-center gap-2 text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 cursor-pointer">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                    </svg>
                    Add OR Group
                </button>
            </div>
        </div>
        <div class="p-6 space-y-4">
            @foreach($conditions as $groupIndex => $group)
                @if($groupIndex > 0)
                    <div class="flex items-center justify-center">
                        <span class="px-3 py-1 text-sm font-bold text-orange-600 dark:text-orange-400 bg-orange-100 dark:bg-orange-900/30 rounded-full">OR</span>
                    </div>
                @endif

                <div class="border border-zinc-200 dark:border-zinc-700 rounded-lg p-4 bg-zinc-50 dark:bg-zinc-800/50">
                    <div class="flex items-center justify-between mb-3">
                        <span class="text-xs font-medium text-zinc-500 dark:text-zinc-400 uppercase tracking-wider">Condition Group {{ $groupIndex + 1 }}</span>
                        @if(count($conditions) > 1)
                            <button wire:click="removeConditionGroup({{ $groupIndex }})"
                                    class="text-red-500 hover:text-red-600 text-xs cursor-pointer">
                                Remove Group
                            </button>
                        @endif
                    </div>

                    <div class="space-y-3">
                        @foreach($group['conditions'] as $conditionIndex => $condition)
                            @if($conditionIndex > 0)
                                <div class="flex items-center justify-center">
                                    <span class="px-2 py-0.5 text-xs font-bold text-blue-600 dark:text-blue-400 bg-blue-100 dark:bg-blue-900/30 rounded">AND</span>
                                </div>
                            @endif

                            <div class="bg-white dark:bg-zinc-800 border border-zinc-200 dark:border-zinc-700 rounded-lg p-4">
                                <div class="grid grid-cols-1 md:grid-cols-12 gap-3 items-end">
                                    <!-- Field Source -->
                                    <div class="md:col-span-2">
                                        <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Source</label>
                                        <select wire:model.live="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.field_source"
                                                class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                            @foreach($fieldSources as $value => $label)
                                                <option value="{{ $value }}">{{ $label }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Field Name -->
                                    <div class="md:col-span-3">
                                        <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Field</label>
                                        @php
                                            $source = $condition['field_source'];
                                            $fields = $this->getFieldsForSource($source);
                                        @endphp
                                        @if(!empty($fields))
                                            <select wire:model="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.field_name"
                                                    class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                                <option value="">Select field</option>
                                                @foreach($fields as $value => $label)
                                                    <option value="{{ $value }}">{{ $label }}</option>
                                                @endforeach
                                            </select>
                                        @else
                                            <input type="text"
                                                   wire:model="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.field_name"
                                                   class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white"
                                                   placeholder="e.g., free sample">
                                        @endif
                                    </div>

                                    <!-- Operator -->
                                    <div class="md:col-span-2">
                                        <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Operator</label>
                                        <select wire:model.live="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.field_operator"
                                                class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                            @foreach($operators as $value => $label)
                                                <option value="{{ $value }}">{{ $label }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Value -->
                                    <div class="md:col-span-3">
                                        <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Value</label>
                                        <input type="text"
                                               wire:model="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.field_value"
                                               class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white"
                                               placeholder="{{ $condition['field_operator'] === 'in_list' ? 'value1,value2' : 'value' }}">
                                    </div>

                                    <!-- Max Value (for between operator) -->
                                    @if($condition['field_operator'] === 'between')
                                        <div class="md:col-span-2">
                                            <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Max</label>
                                            <input type="text"
                                                   wire:model="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.field_value_max"
                                                   class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white"
                                                   placeholder="max value">
                                        </div>
                                    @endif

                                    <!-- Remove Button -->
                                    <div class="md:col-span-1 flex justify-end">
                                        <button wire:click="removeConditionFromGroup({{ $groupIndex }}, {{ $conditionIndex }})"
                                                class="text-red-500 hover:text-red-600 p-1.5 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition-colors cursor-pointer"
                                                title="Remove condition">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>

                                <!-- Case Sensitive Toggle -->
                                <div class="mt-2 flex items-center">
                                    <label class="flex items-center gap-2 cursor-pointer text-xs text-zinc-500 dark:text-zinc-400">
                                        <input type="checkbox"
                                               wire:model="conditions.{{ $groupIndex }}.conditions.{{ $conditionIndex }}.case_sensitive"
                                               class="w-3 h-3 text-blue-600 border-zinc-300 dark:border-zinc-600 rounded focus:ring-blue-500 bg-white dark:bg-zinc-800">
                                        Case sensitive
                                    </label>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <button wire:click="addConditionToGroup({{ $groupIndex }})"
                            class="mt-3 inline-flex items-center gap-1 text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 cursor-pointer">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                        </svg>
                        Add AND Condition
                    </button>
                </div>
            @endforeach
        </div>
    </div>

    <!-- Actions Section -->
    <div class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">THEN (Actions)</h3>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400">Define which rates to include or exclude</p>
                </div>
                <button wire:click="addAction"
                        class="inline-flex items-center gap-2 text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 cursor-pointer">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                    </svg>
                    Add Action
                </button>
            </div>
        </div>
        <div class="p-6">
            @if(count($actions) > 0)
                <div class="space-y-3">
                    @foreach($actions as $index => $action)
                        <div class="bg-zinc-50 dark:bg-zinc-800 border border-zinc-200 dark:border-zinc-700 rounded-lg p-4">
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-3 items-end">
                                <!-- Action Type -->
                                <div class="md:col-span-3">
                                    <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Action</label>
                                    <select wire:model="actions.{{ $index }}.action_type"
                                            class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                        @foreach($actionTypes as $value => $label)
                                            <option value="{{ $value }}">{{ $label }} Rates</option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Pattern Operator -->
                                <div class="md:col-span-3">
                                    <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Match Type</label>
                                    <select wire:model="actions.{{ $index }}.pattern_operator"
                                            class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                        @foreach($patternOperators as $value => $label)
                                            <option value="{{ $value }}">{{ $label }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Rate Pattern -->
                                <div class="md:col-span-5">
                                    <label class="block text-xs font-medium text-zinc-600 dark:text-zinc-400 mb-1">Rate Pattern</label>
                                    <div x-data="{ showCustomInput: !@js(collect($availableRates)->pluck('code')->contains($action['rate_pattern'])) && @js($action['rate_pattern']) !== '' }" class="space-y-2">
                                        <select
                                            x-show="!showCustomInput"
                                            wire:model="actions.{{ $index }}.rate_pattern"
                                            @change="if ($event.target.value === '__custom__') { showCustomInput = true; $wire.set('actions.{{ $index }}.rate_pattern', ''); }"
                                            class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                            <option value="">Select rate or pattern</option>
                                            <optgroup label="Available Rates">
                                                @foreach($availableRates as $rate)
                                                    <option value="{{ $rate['code'] }}">{{ $rate['code'] }} ({{ $rate['display_name'] }})</option>
                                                @endforeach
                                            </optgroup>
                                            <optgroup label="Common Patterns">
                                                <option value="sample">sample (matches any rate with "sample")</option>
                                                <option value="free">free (matches any rate with "free")</option>
                                                <option value="accessory">accessory (matches any rate with "accessory")</option>
                                                <option value="pallet">pallet (matches any rate with "pallet")</option>
                                            </optgroup>
                                            <option value="__custom__">Custom pattern...</option>
                                        </select>
                                        <div x-show="showCustomInput" class="flex gap-2">
                                            <input type="text"
                                                   wire:model="actions.{{ $index }}.rate_pattern"
                                                   class="flex-1 px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white"
                                                   placeholder="Enter custom pattern">
                                            <button type="button" @click="showCustomInput = false"
                                                    class="px-2 py-1.5 text-xs text-zinc-500 hover:text-zinc-700 dark:text-zinc-400 dark:hover:text-zinc-200 cursor-pointer">
                                                Select
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Remove Button -->
                                <div class="md:col-span-1 flex justify-end">
                                    <button wire:click="removeAction({{ $index }})"
                                            class="text-red-500 hover:text-red-600 p-1.5 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition-colors cursor-pointer"
                                            title="Remove action">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <!-- Preview -->
                            <div class="mt-2 text-xs text-zinc-500 dark:text-zinc-400">
                                <span class="{{ $action['action_type'] === 'include' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                    {{ $action['action_type'] === 'include' ? 'Include' : 'Exclude' }}
                                </span>
                                rates where code
                                <span class="font-medium">{{ $action['pattern_operator'] }}</span>
                                "<span class="font-medium">{{ $action['rate_pattern'] ?: '...' }}</span>"
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-8 text-zinc-500 dark:text-zinc-400">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 mx-auto mb-2 text-zinc-300 dark:text-zinc-600">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z" />
                    </svg>
                    <p class="text-sm">No actions defined. Add an action to include or exclude rates.</p>
                    <button wire:click="addAction"
                            class="mt-3 inline-flex items-center gap-2 text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 cursor-pointer">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" />
                        </svg>
                        Add First Action
                    </button>
                </div>
            @endif
        </div>
    </div>

    <!-- Footer Actions -->
    <div class="flex items-center justify-between py-4">
        <a href="{{ route('bigcommerce.rules.index', ['storeHash' => $storeHash]) }}"
           class="text-sm text-zinc-500 dark:text-zinc-400 hover:text-zinc-700 dark:hover:text-zinc-200 transition-colors">
            Cancel
        </a>
        <button wire:click="save"
                class="px-6 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 transition-colors cursor-pointer">
            {{ $isEditing ? 'Update Rule' : 'Create Rule' }}
        </button>
    </div>
</div>
