<div class="flex h-full w-full flex-1 flex-col gap-6 rounded-xl">
    <!-- Add New Carrier Form -->
    <div class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="max-w-2xl mx-auto p-6">
            <!-- Stepper Navigation -->
            <div class="flex items-center mb-8">
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 rounded-full flex items-center justify-center font-bold text-white {{ $step === 1 ? 'bg-blue-600' : 'bg-zinc-400 dark:bg-zinc-600' }}">1</div>
                        <span class="ml-2 text-zinc-900 dark:text-white font-semibold">Carrier Info</span>
                    </div>
                </div>
                <div class="flex-1 border-t-2 mx-2 border-zinc-200 dark:border-zinc-700"></div>
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 rounded-full flex items-center justify-center font-bold text-white {{ $step === 2 ? 'bg-blue-600' : 'bg-zinc-400 dark:bg-zinc-600' }}">2</div>
                        <span class="ml-2 text-zinc-900 dark:text-white font-semibold">Rates</span>
                    </div>
                </div>
                <div class="flex-1 border-t-2 mx-2 border-zinc-200 dark:border-zinc-700"></div>
                <div class="flex-1">
                    <div class="flex items-center">
                        <div class="w-8 h-8 rounded-full flex items-center justify-center font-bold text-white {{ $step === 3 ? 'bg-blue-600' : 'bg-zinc-400 dark:bg-zinc-600' }}">3</div>
                        <span class="ml-2 text-zinc-900 dark:text-white font-semibold">Review</span>
                    </div>
                </div>
            </div>

            <!-- Step 1: Carrier Info -->
            @if($step === 1)
                <form wire:submit.prevent="nextStep" class="space-y-4">
                    <div>
                        <label for="carrier_info_code" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">Carrier Code</label>
                        <input type="text" id="carrier_info_code" wire:model="carrier_info_code"
                               class="w-full px-3 py-2 border border-zinc-300 dark:border-zinc-600 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white" />
                        @error('carrier_info_code') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label for="carrier_info_display_name" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">Carrier Display Name</label>
                        <input type="text" id="carrier_info_display_name" wire:model="carrier_info_display_name"
                               class="w-full px-3 py-2 border border-zinc-300 dark:border-zinc-600 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white" />
                        @error('carrier_info_display_name') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-blue-600 text-white font-semibold py-2 px-4 rounded-md hover:bg-blue-700 transition-colors">Next</button>
                    </div>
                </form>
            @endif

            <!-- Step 2: Add Rates -->
            @if($step === 2)
                <div class="mb-4">
                    <form wire:submit.prevent="addRate" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                        <div>
                            <label class="block text-sm text-zinc-700 dark:text-zinc-300 mb-1">Code</label>
                            <input type="text" wire:model="rate_code" class="w-full px-2 py-1 border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white" />
                        </div>
                        <div>
                            <label class="block text-sm text-zinc-700 dark:text-zinc-300 mb-1">Description</label>
                            <input type="text" wire:model="rate_description" class="w-full px-2 py-1 border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white" />
                        </div>
                        <div>
                            <label class="block text-sm text-zinc-700 dark:text-zinc-300 mb-1">Currency</label>
                            <select wire:model="rate_currency" class="w-full px-2 py-1 border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white">
                                <option value="">Select currency</option>
                                @foreach($currencies as $currency)
                                    <option value="{{ $currency }}">{{ $currency }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm text-zinc-700 dark:text-zinc-300 mb-1">Amount</label>
                            <input type="number" step="0.01" wire:model="rate_amount" class="w-full px-2 py-1 border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white" />
                        </div>
                        <div class="md:col-span-4 flex justify-end mt-2">
                            <button type="submit" class="cursor-pointer bg-blue-600 text-white font-semibold py-1 px-4 rounded hover:bg-blue-700 transition-colors">Add Rate</button>
                        </div>
                    </form>
                </div>
                <div>
                    <h4 class="text-zinc-900 dark:text-white font-semibold mb-2">Rates Added</h4>
                    <ul>
                        @forelse($rates as $i => $rate)
                            <li class="flex items-center justify-between bg-zinc-100 dark:bg-zinc-800 rounded p-2 mb-2">
                                <span class="text-zinc-900 dark:text-white">{{ $rate['code'] }} ({{ $rate['currency'] }} {{ $rate['amount'] }}) - {{ $rate['description'] }}</span>
                                <button wire:click="removeRate({{ $i }})" class="text-red-500 hover:underline ml-2">Remove</button>
                            </li>
                        @empty
                            <li class="text-zinc-400">No rates added yet.</li>
                        @endforelse
                    </ul>
                </div>
                <div class="flex justify-between mt-4">
                    <button wire:click="prevStep" class="bg-zinc-300 dark:bg-zinc-700 text-zinc-900 dark:text-white font-semibold py-2 px-4 rounded-md hover:bg-zinc-400 dark:hover:bg-zinc-600 transition-colors">Back</button>
                    <button wire:click="nextStep" class="bg-blue-600 text-white font-semibold py-2 px-4 rounded-md hover:bg-blue-700 transition-colors">Next</button>
                </div>
            @endif

            <!-- Step 3: Review & Confirm -->
            @if($step === 3)
                <div class="mb-4">
                    <h4 class="text-zinc-900 dark:text-white font-semibold mb-2">Carrier Info</h4>
                    <div class="bg-zinc-100 dark:bg-zinc-800 rounded p-3 mb-2">
                        <div class="text-zinc-900 dark:text-white"><span class="font-bold">Code:</span> {{ $carrier_info_code }}</div>
                        <div class="text-zinc-900 dark:text-white"><span class="font-bold">Display Name:</span> {{ $carrier_info_display_name }}</div>
                    </div>
                    <h4 class="text-zinc-900 dark:text-white font-semibold mb-2">Rates</h4>
                    <ul>
                        @forelse($rates as $rate)
                            <li class="bg-zinc-100 dark:bg-zinc-800 rounded p-2 mb-2">
                                <span class="text-zinc-900 dark:text-white">{{ $rate['code'] }} ({{ $rate['currency'] }} {{ $rate['amount'] }}) - {{ $rate['description'] }}</span>
                            </li>
                        @empty
                            <li class="text-zinc-400">No rates added.</li>
                        @endforelse
                    </ul>
                </div>
                <div class="flex justify-between mt-4">
                    <button wire:click="prevStep" class="bg-zinc-300 dark:bg-zinc-700 text-zinc-900 dark:text-white font-semibold py-2 px-4 rounded-md hover:bg-zinc-400 dark:hover:bg-zinc-600 transition-colors">Back</button>
                    <button wire:click="saveCarrierWithRates" class="bg-green-600 text-white font-semibold py-2 px-4 rounded-md hover:bg-green-700 transition-colors">Finish</button>
                </div>
            @endif
        </div>
    </div>

    <!-- Carriers List -->
    <div class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Added Carriers</h3>
            <p class="text-sm text-zinc-500 dark:text-zinc-400">Manage your shipping carriers and their rates</p>
        </div>

        <div class="p-6">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                @forelse($carriers as $carrier)
                    <div class="bg-zinc-50 dark:bg-zinc-800 border border-zinc-200 dark:border-zinc-700 rounded-lg p-5 flex flex-col justify-between">
                        <div>
                            <div class="font-bold text-zinc-900 dark:text-white text-lg mb-1">{{ $carrier->carrier_info_display_name }}</div>
                            <div class="text-zinc-500 dark:text-zinc-400 text-sm mb-3">Code: {{ $carrier->carrier_info_code }}</div>
                            <span class="inline-block bg-blue-600 text-white text-xs px-2 py-1 rounded">
                                {{ $carrier->rates->count() }} Rate{{ $carrier->rates->count() !== 1 ? 's' : '' }}
                            </span>
                        </div>
                        <div class="flex items-center justify-between mt-4 pt-4 border-t border-zinc-200 dark:border-zinc-700">
                            <button wire:click="showCarrierModal({{ $carrier->id }})" class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium text-sm cursor-pointer transition-colors">
                                View Details
                            </button>
                            <button wire:click="deleteCarrier({{ $carrier->id }})" class="text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 font-medium text-sm cursor-pointer transition-colors" onclick="return confirm('Are you sure you want to delete this carrier?')">
                                Delete
                            </button>
                        </div>
                    </div>
                @empty
                    <div class="col-span-full text-center py-12">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-12 h-12 text-zinc-300 dark:text-zinc-600 mx-auto mb-3">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                        </svg>
                        <p class="text-sm font-medium text-zinc-900 dark:text-white">No carriers added yet</p>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400 mt-1">Add your first carrier using the form above</p>
                    </div>
                @endforelse
            </div>

            @if($carriers->hasPages())
                <div class="mt-6 pt-4 border-t border-zinc-200 dark:border-zinc-700">
                    {{ $carriers->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Modal for Carrier Details -->
    @if($showModal && $selectedCarrier)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm p-4">
            <div class="bg-white dark:bg-zinc-900 rounded-xl shadow-xl max-w-lg w-full max-h-[80vh] flex flex-col border border-zinc-200 dark:border-zinc-700">
                <!-- Modal Header (sticky) -->
                <div class="flex items-center justify-between px-4 py-3 border-b border-zinc-200 dark:border-zinc-700 flex-shrink-0">
                    <div>
                        <div class="font-bold text-lg text-zinc-900 dark:text-white">{{ $selectedCarrier->carrier_info_display_name }}</div>
                        <div class="text-zinc-500 dark:text-zinc-400 text-xs">Code: {{ $selectedCarrier->carrier_info_code }}</div>
                    </div>
                    <button wire:click="closeModal" class="cursor-pointer text-zinc-500 dark:text-zinc-400 hover:text-zinc-700 dark:hover:text-zinc-200 transition-colors">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>

                <!-- Modal Body (scrollable) -->
                <div class="flex-1 overflow-y-auto px-4 py-3">
                    <!-- Add Rate Toggle -->
                    <div class="flex items-center justify-between mb-3">
                        <button wire:click="toggleAddRateForm" class="cursor-pointer text-blue-600 dark:text-blue-400 font-medium text-sm hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                            {{ $showAddRateForm ? 'Hide Form' : '+ Add Rate' }}
                        </button>
                    </div>

                    <!-- Add Rate Form (collapsible) -->
                    @if($showAddRateForm)
                        <form wire:submit.prevent="addRateToCarrier" class="bg-zinc-100 dark:bg-zinc-800 rounded-lg p-3 mb-4">
                            <div class="grid grid-cols-2 gap-2">
                                <div>
                                    <label class="block text-xs text-zinc-600 dark:text-zinc-300 mb-1">Code</label>
                                    <input type="text" wire:model="modal_rate_code" class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white" />
                                </div>
                                <div>
                                    <label class="block text-xs text-zinc-600 dark:text-zinc-300 mb-1">Description</label>
                                    <input type="text" wire:model="modal_rate_description" class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white" />
                                </div>
                                <div>
                                    <label class="block text-xs text-zinc-600 dark:text-zinc-300 mb-1">Currency</label>
                                    <select wire:model="modal_rate_currency" class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white">
                                        <option value="">Select</option>
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency }}">{{ $currency }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-xs text-zinc-600 dark:text-zinc-300 mb-1">Amount</label>
                                    <input type="number" step="0.01" wire:model="modal_rate_amount" class="w-full px-2 py-1.5 text-sm border border-zinc-300 dark:border-zinc-600 rounded bg-white dark:bg-zinc-700 text-zinc-900 dark:text-white" />
                                </div>
                            </div>
                            <div class="flex justify-end mt-3">
                                <button type="submit" class="bg-blue-600 text-white text-sm font-medium py-1.5 px-3 rounded hover:bg-blue-700 transition-colors cursor-pointer">Add</button>
                            </div>
                        </form>
                    @endif

                    <!-- Rates List -->
                    <div class="text-sm font-semibold text-zinc-900 dark:text-white mb-2">Rates ({{ $paginatedRates->total() }})</div>
                    <div class="space-y-2">
                        @forelse($paginatedRates as $rate)
                            <div class="bg-zinc-50 dark:bg-zinc-800 border border-zinc-200 dark:border-zinc-700 rounded-lg p-3">
                                <div class="flex justify-between items-center">
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center gap-2">
                                            <span class="font-medium text-zinc-900 dark:text-white text-sm">{{ $rate->code }}</span>
                                            @if($rate->rateCost)
                                                <span class="text-green-600 dark:text-green-400 text-sm font-medium">
                                                    {{ $rate->rateCost->currency }} {{ number_format($rate->rateCost->amount, 2) }}
                                                </span>
                                            @endif
                                        </div>
                                        <div class="text-zinc-500 dark:text-zinc-400 text-xs truncate">{{ $rate->display_name }}</div>
                                    </div>
                                    <div class="flex items-center gap-3 ml-2 flex-shrink-0">
                                        <button @click="$dispatch('open-product-drawer', { rateDetailsId: {{ $rate->id }} })" class="cursor-pointer text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 text-xs font-medium transition-colors">
                                            Products
                                        </button>
                                        <button
                                            x-data
                                            @click.prevent="if (confirm('Delete this rate?')) { $wire.deleteRate({{ $rate->id }}) }"
                                            class="text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 text-xs font-medium cursor-pointer transition-colors"
                                        >
                                            Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-6 text-zinc-500 dark:text-zinc-400 text-sm">No rates for this carrier.</div>
                        @endforelse
                    </div>

                    @if($paginatedRates->hasPages())
                        <div class="mt-3 text-sm">
                            {{ $paginatedRates->links() }}
                        </div>
                    @endif
                </div>

                <!-- Modal Footer (sticky) -->
                <div class="flex justify-end gap-2 px-4 py-3 border-t border-zinc-200 dark:border-zinc-700 flex-shrink-0">
                    <button wire:click="closeModal" class="cursor-pointer bg-zinc-200 dark:bg-zinc-700 text-zinc-900 dark:text-white text-sm font-medium py-1.5 px-3 rounded hover:bg-zinc-300 dark:hover:bg-zinc-600 transition-colors">
                        Close
                    </button>
                    <button wire:click="finishAddingRates" class="bg-green-600 text-white text-sm font-medium py-1.5 px-3 rounded hover:bg-green-700 transition-colors cursor-pointer">
                        Done
                    </button>
                </div>
            </div>
        </div>
    @endif

    <livewire:bigcommerce.big-commerce.product-rate-attachment />
</div>
