<?php

use Illuminate\Support\Facades\Route;
use Mtc\BigCommerceRates\Http\Middleware\JwtAuthenticate;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Product\Import as ProductImport;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Carrier;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Rules;
use Mtc\BigCommerceRates\Livewire\BigCommerce\RuleBuilder;
use App\Http\Livewire\Dashboard; // or your package's component


Route::view('dashboard-iframe', 'dashboard')
    ->middleware(['verified'])
    ->name('dashboard.iframe');

Route::get('productImport/{storeHash}', ProductImport::class)->name('productImport');
Route::any('carrier/{storeHash}', Carrier::class)->name('carrier');

// Shipping Rules Routes
Route::prefix('bigcommerce')->name('bigcommerce.')->group(function () {
    Route::get('rules/{storeHash}', Rules::class)->name('rules.index');
    Route::get('rules/{storeHash}/create', RuleBuilder::class)->name('rules.create');
    Route::get('rules/{storeHash}/{rule}/edit', RuleBuilder::class)->name('rules.edit');
    Route::view('docs/shipping-rules', 'bigcommerce::docs.user-manual')->name('docs.shipping-rules');
});
