<?php

    namespace Mtc\BigCommerceRates\Models\BigCommerce\Rates;

    use Illuminate\Database\Eloquent\Model;
    use Mtc\BigCommerceRates\Models\BigCommerce\Product;
    use Mtc\BigCommerceRates\Models\BigCommerce\Rates\StoreCarrier;
    use Mtc\BigCommerceRates\Models\BigCommerce\Rates\RateCost;

    class RateDetails extends Model
    {
        // Explicit table name to match migration
        protected $table = 'rate_details';

        // Mass assignable fields
        protected $fillable = [
            'carrier_id',
            'code',
            'rate_id',
            'display_name',
        ];

        /**
         * Get the rate type that owns this rate detail.
         */
        public function rateType()
        {
            return $this->belongsTo(StoreCarrier::class, 'carrier_id');
        }

        /**
         * Get the cost(s) for this rate detail.
         */
        public function rateCost()
        {
            return $this->hasOne(RateCost::class, 'rate_details_id');
        }

        public function products()
        {
            return $this->belongsToMany(
                Product::class,
                'product_rates',
                'rate_details_id', // Foreign key on the pivot table for this model (RateDetails)
                'store_product_id' // Foreign key on the pivot table for the related model (Product)
            )->withTimestamps();

        }
    }
