<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Main shipping rules table
        Schema::create('shipping_rules', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('store_id');
            $table->string('name');
            $table->text('description')->nullable();
            $table->boolean('enabled')->default(true);
            $table->integer('priority')->default(0);
            $table->enum('match_type', ['all', 'any'])->default('all');
            $table->enum('condition_logic', ['and', 'or'])->default('and');
            $table->timestamps();

            $table->foreign('store_id')
                ->references('id')
                ->on('store_installations')
                ->onDelete('cascade');

            $table->index(['store_id', 'enabled', 'priority']);
        });

        // Rule conditions table
        Schema::create('shipping_rule_conditions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('rule_id');
            $table->integer('group_index')->default(0);
            $table->enum('field_source', ['cart', 'item', 'product', 'option', 'custom_field']);
            $table->string('field_name');
            $table->enum('field_operator', [
                'equals',
                'not_equals',
                'contains',
                'not_contains',
                'greater_than',
                'less_than',
                'between',
                'in_list',
                'regex'
            ])->default('equals');
            $table->string('field_value');
            $table->string('field_value_max')->nullable();
            $table->boolean('case_sensitive')->default(false);
            $table->timestamps();

            $table->foreign('rule_id')
                ->references('id')
                ->on('shipping_rules')
                ->onDelete('cascade');

            $table->index(['rule_id', 'group_index']);
        });

        // Rule actions table
        Schema::create('shipping_rule_actions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('rule_id');
            $table->enum('action_type', ['include', 'exclude']);
            $table->string('rate_pattern');
            $table->enum('pattern_operator', ['contains', 'equals', 'regex'])->default('contains');
            $table->timestamps();

            $table->foreign('rule_id')
                ->references('id')
                ->on('shipping_rules')
                ->onDelete('cascade');

            $table->index('rule_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('shipping_rule_actions');
        Schema::dropIfExists('shipping_rule_conditions');
        Schema::dropIfExists('shipping_rules');
    }
};
