<div class="flex h-full w-full flex-1 flex-col gap-6 rounded-xl">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-zinc-900 dark:text-white">Shipping Rules Documentation</h2>
            <p class="text-sm text-zinc-500 dark:text-zinc-400">Learn how to create and manage shipping rules</p>
        </div>
    </div>

    <!-- Quick Navigation -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <a href="#overview" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-blue-500 dark:hover:border-blue-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-blue-600 dark:text-blue-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-blue-600 dark:group-hover:text-blue-400">Overview</span>
            </div>
        </a>
        <a href="#conditions" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-purple-500 dark:hover:border-purple-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-purple-600 dark:text-purple-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 11-3 0m3 0a1.5 1.5 0 10-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-9.75 0h9.75" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-purple-600 dark:group-hover:text-purple-400">Conditions</span>
            </div>
        </a>
        <a href="#actions" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-orange-500 dark:hover:border-orange-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-orange-100 dark:bg-orange-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-orange-600 dark:text-orange-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-orange-600 dark:group-hover:text-orange-400">Actions</span>
            </div>
        </a>
        <a href="#examples" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-cyan-100 dark:bg-cyan-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-cyan-600 dark:text-cyan-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-cyan-600 dark:group-hover:text-cyan-400">Examples</span>
            </div>
        </a>
    </div>

    <!-- Overview Section -->
    <section id="overview" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-blue-600 dark:text-blue-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Overview</h3>
            </div>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                The Shipping Rules system allows you to dynamically control which shipping rates are shown to customers at checkout based on what's in their cart. Instead of hardcoding shipping logic, you can create flexible rules that automatically include or exclude specific shipping options.
            </p>

            <div class="grid md:grid-cols-2 gap-4 mb-6">
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Dynamic Filtering</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Show or hide shipping rates based on cart contents</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Complex Logic</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Combine multiple conditions with AND/OR operators</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Priority System</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Control which rule takes precedence when multiple rules match</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Multiple Data Sources</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Check cart data, product options, custom fields, and more</p>
                    </div>
                </div>
            </div>

            <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-700/50 rounded-lg p-4">
                <div class="flex items-start gap-3">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-amber-600 dark:text-amber-400 flex-shrink-0 mt-0.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                    </svg>
                    <div>
                        <h4 class="font-medium text-amber-800 dark:text-amber-300">Important</h4>
                        <p class="text-sm text-amber-700 dark:text-amber-200/80">Rules are evaluated in priority order (lowest number first). The <strong>first matching rule</strong> determines which shipping rates are shown. If no rules match, all rates are displayed.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Conditions Section -->
    <section id="conditions" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-purple-600 dark:text-purple-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 11-3 0m3 0a1.5 1.5 0 10-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-9.75 0h9.75" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Conditions</h3>
            </div>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                Conditions define when a rule should be applied. Each condition checks a specific field against a value using an operator.
            </p>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Field Sources</h4>
            <div class="overflow-x-auto mb-6">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b border-zinc-200 dark:border-zinc-700">
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Source</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Description</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Available Fields</th>
                        </tr>
                    </thead>
                    <tbody class="text-zinc-600 dark:text-zinc-300">
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300 rounded-md text-xs font-medium">Cart</span>
                            </td>
                            <td class="py-3 px-4">Cart-level information including shipping destination</td>
                            <td class="py-3 px-4">
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">country_iso2</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">state</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">city</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">postal_code</code>
                            </td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-300 rounded-md text-xs font-medium">Item</span>
                            </td>
                            <td class="py-3 px-4">Line item data from the checkout</td>
                            <td class="py-3 px-4">
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">quantity</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">sku</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">name</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">price</code>
                            </td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-amber-100 dark:bg-amber-900/30 text-amber-700 dark:text-amber-300 rounded-md text-xs font-medium">Product</span>
                            </td>
                            <td class="py-3 px-4">Product catalog data</td>
                            <td class="py-3 px-4">
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">categories</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">brand_id</code>
                                <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded ml-1">weight</code>
                            </td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-cyan-100 dark:bg-cyan-900/30 text-cyan-700 dark:text-cyan-300 rounded-md text-xs font-medium">Option</span>
                            </td>
                            <td class="py-3 px-4">Product options selected by customer</td>
                            <td class="py-3 px-4 text-zinc-400 dark:text-zinc-500 italic">Enter option name (e.g., "free sample", "color")</td>
                        </tr>
                        <tr>
                            <td class="py-3 px-4">
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-700 dark:text-pink-300 rounded-md text-xs font-medium">Custom Field</span>
                            </td>
                            <td class="py-3 px-4">Product custom fields from BigCommerce</td>
                            <td class="py-3 px-4 text-zinc-400 dark:text-zinc-500 italic">Enter custom field name (e.g., "item type", "pallet")</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Operators</h4>
            <div class="grid md:grid-cols-2 gap-4 mb-6">
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-3">Text Operators</h5>
                    <ul class="space-y-2 text-sm text-zinc-600 dark:text-zinc-300">
                        <li><code class="text-blue-600 dark:text-blue-400">equals</code> - Exact match</li>
                        <li><code class="text-blue-600 dark:text-blue-400">not_equals</code> - Does not match</li>
                        <li><code class="text-blue-600 dark:text-blue-400">contains</code> - Contains the text</li>
                        <li><code class="text-blue-600 dark:text-blue-400">not_contains</code> - Does not contain</li>
                        <li><code class="text-blue-600 dark:text-blue-400">in_list</code> - Matches any value in comma-separated list</li>
                        <li><code class="text-blue-600 dark:text-blue-400">regex</code> - Regular expression match</li>
                    </ul>
                </div>
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-3">Numeric Operators</h5>
                    <ul class="space-y-2 text-sm text-zinc-600 dark:text-zinc-300">
                        <li><code class="text-green-600 dark:text-green-400">greater_than</code> - Value is greater than</li>
                        <li><code class="text-green-600 dark:text-green-400">less_than</code> - Value is less than</li>
                        <li><code class="text-green-600 dark:text-green-400">between</code> - Value is within range (inclusive)</li>
                    </ul>
                </div>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">AND/OR Logic</h4>
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <div class="space-y-4">
                    <div class="flex items-center gap-3">
                        <span class="px-2 py-0.5 text-xs font-bold text-blue-700 dark:text-blue-400 bg-blue-100 dark:bg-blue-900/30 rounded">AND</span>
                        <span class="text-zinc-700 dark:text-zinc-300">All conditions in a group must be true - Use "Add AND Condition"</span>
                    </div>
                    <div class="flex items-center gap-3">
                        <span class="px-2 py-0.5 text-xs font-bold text-orange-700 dark:text-orange-400 bg-orange-100 dark:bg-orange-900/30 rounded">OR</span>
                        <span class="text-zinc-700 dark:text-zinc-300">Any one of the groups must be true - Use "Add OR Group"</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Actions Section -->
    <section id="actions" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-orange-100 dark:bg-orange-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-orange-600 dark:text-orange-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Actions</h3>
            </div>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                Actions determine which shipping rates to show when a rule's conditions are met.
            </p>

            <div class="grid md:grid-cols-2 gap-4 mb-6">
                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-700/50 rounded-lg p-4">
                    <div class="flex items-center gap-2 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-600 dark:text-green-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <h4 class="font-medium text-green-800 dark:text-green-300">Include Rates</h4>
                    </div>
                    <p class="text-sm text-green-700 dark:text-green-200/80">Only show rates that match the specified pattern. All other rates will be hidden.</p>
                </div>
                <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-700/50 rounded-lg p-4">
                    <div class="flex items-center gap-2 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-red-600 dark:text-red-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                        </svg>
                        <h4 class="font-medium text-red-800 dark:text-red-300">Exclude Rates</h4>
                    </div>
                    <p class="text-sm text-red-700 dark:text-red-200/80">Hide rates that match the specified pattern. All other rates will be shown.</p>
                </div>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Rate Pattern Matching</h4>
            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b border-zinc-200 dark:border-zinc-700">
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Match Type</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Description</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Example</th>
                        </tr>
                    </thead>
                    <tbody class="text-zinc-600 dark:text-zinc-300">
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4"><code class="text-blue-600 dark:text-blue-400">contains</code></td>
                            <td class="py-3 px-4">Rate code contains the pattern</td>
                            <td class="py-3 px-4">"sample" matches <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">free_sample</code>, <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">sample_delivery</code></td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4"><code class="text-blue-600 dark:text-blue-400">equals</code></td>
                            <td class="py-3 px-4">Rate code exactly matches</td>
                            <td class="py-3 px-4">"std_delivery" matches only <code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">std_delivery</code></td>
                        </tr>
                        <tr>
                            <td class="py-3 px-4"><code class="text-blue-600 dark:text-blue-400">regex</code></td>
                            <td class="py-3 px-4">Regular expression match</td>
                            <td class="py-3 px-4">"^pallet_" matches codes starting with "pallet_"</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>

    <!-- Examples Section -->
    <section id="examples" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-cyan-100 dark:bg-cyan-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-cyan-600 dark:text-cyan-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Examples</h3>
            </div>
        </div>
        <div class="p-6 space-y-4">
            <!-- Example 1 -->
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-1">Free Sample Shipping</h4>
                <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-3">Only show sample shipping rates when all items are free samples</p>
                <div class="grid md:grid-cols-3 gap-4 text-sm">
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Condition</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">Option "free sample" <span class="text-blue-600 dark:text-blue-400">equals</span> "yes"</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Action</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300"><span class="text-green-600 dark:text-green-400">Include</span> rates containing "sample"</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Match Type</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">ALL items</div>
                    </div>
                </div>
            </div>

            <!-- Example 2 -->
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-1">Pallet Shipping</h4>
                <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-3">Show only pallet shipping when any item requires a pallet</p>
                <div class="grid md:grid-cols-3 gap-4 text-sm">
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Condition</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">Custom Field "pallet" <span class="text-blue-600 dark:text-blue-400">equals</span> "T"</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Actions</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">
                            <span class="text-green-600 dark:text-green-400">Include</span> "pallet",
                            <span class="text-red-600 dark:text-red-400">Exclude</span> "free", "sample"
                        </div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Match Type</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">ANY item</div>
                    </div>
                </div>
            </div>

            <!-- Example 3 -->
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-1">Country-Specific Rates</h4>
                <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-3">Show international shipping only for non-UK destinations</p>
                <div class="grid md:grid-cols-3 gap-4 text-sm">
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Condition</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">Cart "country_iso2" <span class="text-blue-600 dark:text-blue-400">not_equals</span> "GB"</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Action</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300"><span class="text-green-600 dark:text-green-400">Include</span> rates containing "international"</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Match Type</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">ALL items</div>
                    </div>
                </div>
            </div>

            <!-- Example 4 -->
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-1">Standard Shipping (Default)</h4>
                <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-3">Show standard rates and hide special shipping options (priority 99 - evaluated last)</p>
                <div class="grid md:grid-cols-3 gap-4 text-sm">
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Condition</span>
                        <div class="mt-1 text-zinc-400 dark:text-zinc-500 italic">No conditions (always matches)</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Actions</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300"><span class="text-red-600 dark:text-red-400">Exclude</span> "free", "sample", "accessory"</div>
                    </div>
                    <div>
                        <span class="text-xs font-semibold text-zinc-500 dark:text-zinc-400 uppercase">Priority</span>
                        <div class="mt-1 text-zinc-700 dark:text-zinc-300">99 (lowest)</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Troubleshooting Section -->
    <section id="troubleshooting" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-red-100 dark:bg-red-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-red-600 dark:text-red-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.42 15.17L17.25 21A2.652 2.652 0 0021 17.25l-5.877-5.877M11.42 15.17l2.496-3.03c.317-.384.74-.626 1.208-.766M11.42 15.17l-4.655 5.653a2.548 2.548 0 11-3.586-3.586l6.837-5.63m5.108-.233c.55-.164 1.163-.188 1.743-.14a4.5 4.5 0 004.486-6.336l-3.276 3.277a3.004 3.004 0 01-2.25-2.25l3.276-3.276a4.5 4.5 0 00-6.336 4.486c.091 1.076-.071 2.264-.904 2.95l-.102.085m-1.745 1.437L5.909 7.5H4.5L2.25 3.75l1.5-1.5L7.5 4.5v1.409l4.26 4.26m-1.745 1.437l1.745-1.437m6.615 8.206L15.75 15.75M4.867 19.125h.008v.008h-.008v-.008z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Troubleshooting</h3>
            </div>
        </div>
        <div class="p-6 space-y-4">
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">No shipping rates appear at checkout</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Check that at least one rule matches the cart contents</li>
                    <li>* Verify the actions aren't excluding all available rates</li>
                    <li>* Ensure you have carriers and rates configured in the Carrier section</li>
                </ul>
            </div>

            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">Wrong shipping rates showing</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Check rule priorities - lower numbers are evaluated first</li>
                    <li>* Verify conditions are using the correct field source and operator</li>
                    <li>* Remember that only the FIRST matching rule's actions are applied</li>
                </ul>
            </div>

            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">Condition not matching</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Check if "Case sensitive" is enabled when it shouldn't be</li>
                    <li>* For options and custom fields, verify the exact name spelling</li>
                    <li>* Use "contains" instead of "equals" for partial matches</li>
                </ul>
            </div>

            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">Rule not being evaluated</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Ensure the rule is enabled (toggle is on)</li>
                    <li>* A higher-priority rule might be matching first</li>
                    <li>* Check that conditions aren't empty or invalid</li>
                </ul>
            </div>
        </div>
    </section>
</div>
