<?php

use Illuminate\Support\Facades\Route;
use Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Proxy as BigCommerceProxy;
use Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Shipping\CarrierController as ShippingCarrierController;

    Route::controller(BigCommerceProxy::class)
        ->group(function(){
            Route::any('/{store_hash}/{endpoint}','proxyBigCommerceAPIRequest')
                ->where('endpoint', 'v2/.*|v3/.*')->name('proxyBigCommerceAPIRequest');
        });


    Route::name("shipping")
        ->prefix("shipping")
        ->controller(ShippingCarrierController::class)
        ->group(function () {
            Route::any('rates', 'rates')->name('rates');
            Route::post('validate-connection', 'validateConnection')->name('validate-connection');
            Route::post('available-shipping-types', 'available-shipping-types')->name('available-shipping-types');
        });
