<?php

namespace Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Webhook;

use App\Http\Controllers\Controller;
use Illuminate\Http\Client\HttpClientException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Mtc\BigCommerceRates\Models\BigCommerce\Rates\StoreCarrier;
use Mtc\BigCommerceRates\Models\StoreInstallation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Mtc\BigCommerceRates\Models\BigCommerce\Product as ProductModel;


class Product extends Controller
{
    const ENDPOINT= "v3/catalog/products";

    protected string $hash;
    protected string $scope;
    protected int $productId;


    public function __construct(
        public Request $request
    )
    {
        $this->productId = $this->request->input('data.id');
        $this->hash = $this->request->input('hash');
        $this->scope = $this->request->input('scope');

        $this->storeId = StoreInstallation::where('store_hash', $this->hash)->first()->id;

    }



    public function proccessProduct(string $action)
    {

        if ($this->hash && Cache::has("webhook:$this->hash")) {
            Log::info("Duplicate Webhook Ignored for Product ID: {$this->productId}, Scope: {$this->scope}");
            return response()->json(['message' => 'Duplicate webhook ignored'], 200);
        }

        // Allow only "store/product/created" or "store/product/updated"
        if (!in_array($this->scope, ['store/product/created', 'store/product/updated', 'store/product/deleted'])) {
            return response()->json(['message' => 'Invalid webhook scope'], 400);
        }


        match($this->scope) {
            'store/product/deleted' => $this->handleDeletedProduct(),
            'store/product/updated' => $this->handleUpdatedProduct(),
            'store/product/created' => $this->handleCreatedProduct(),

        };
        Cache::put("webhook:$hash", true, now()->addSeconds(500));
        return response()->json(['message' => "Webhook Received for scope: {$this->scope}"], 200);
    }

    protected function handleDeletedProduct()
    {
        $product = ProductModel::where('product_id',$this->productId)
            ->where("store_id",$this->storeId)
            ->first();
        if ($product) {
            $product->delete();
            Log::info("Webhook : Product {$this->productId} Deleted");
            return response()->json(['message' => "Webhook Received: Product {$this->productId} Deleted"], 200);
        }
        // If the product does not exist, return a 404
        Log::info("Webhook : Product {$this->productId} NOT FOUND");
        return response()->json(['message' => "Product {$this->productId} not found"], 404);
        // Handle product deletion logic here
    }


    protected function getProduct(){
        $productEndpoint =  env('APP_URL')."bc-api/{$storeHash}/".self::ENDPOINT."/{$this->productId}";
        $queryParams = [
            "include" => "custom_fields,options,modifiers,variants",
            "include_fields" => "id,name,sku,price,categories,date_created,is_visible,inventory_level,total_sold,brand_id",
        ];


        try{

            $response = Http::timeout(400)
                ->connectTimeout(1)
                ->get($productEndpoint, $queryParams)
                ->throw()->collect();


            return $response;
        }catch (HttpClientException $e){
            Log::error("Error fetching product data: " . $e->getMessage());
            return response()->json(['message' => "Product {$this->productId} not found", "error"=>$e->getMessage()], 404);
        }
    }


    protected function handleUpdatedProduct()
    {
        $product = $this->getProduct();
    }

    protected function handleCreatedProduct()
    {
        $product = collect($this->getProduct());

        ProductModel::create();


    }

}
