<?php
    namespace Mtc\BigCommerceRates\Livewire\BigCommerce;

use Livewire\Component;
use Livewire\WithPagination;
use Mtc\BigCommerceRates\Models\BigCommerce\Product;
use Mtc\BigCommerceRates\Models\BigCommerce\Rates\RateDetails;
use Illuminate\Support\Facades\DB;
use Livewire\Livewire;


class ProductRateAttachment extends Component
{
    use WithPagination;

    public $rateDetailsId;
    public $search = '';
    public $filterBy = 'name';
    public $showDrawer = false;

    protected $queryString = ['search', 'filterBy'];

    protected $listeners = ['open-product-drawer' => 'openDrawer'];



    public function openDrawer($rateDetailsId)
    {
        $this->rateDetailsId = $rateDetailsId;
        $this->showDrawer = true;
        $this->resetPage();
    }

    public function closeDrawer()
    {
        $this->showDrawer = false;
    }

    public function attachProduct($productId)
    {
        $rate = RateDetails::find($this->rateDetailsId);
        if ($rate) {
            $rate->products()->syncWithoutDetaching([$productId]);
            //Livewire::dispatch('productAttached');
        }
    }

    public function detachProduct($productId)
    {
        $rate = RateDetails::find($this->rateDetailsId);
        if ($rate) {
            $rate->products()->detach($productId);
            //Livewire::dispatch('productDetached');
        }
    }

    public function updatingSearch()
    {
        $this->resetPage('attachedProdPage');
    }

    public function getFilteredProductsProperty()
    {
        $storeId = auth()->user()?->storeInstallation?->id;
        $attachedProductIds = RateDetails::find($this->rateDetailsId)?->products()->pluck('store_product.id')->toArray() ?? [];


        $query = Product::query()->where('store_id',(auth()->user()?->storeInstallation?->id))
            ->whereNotIn('store_product.id', $attachedProductIds); // Exclude attached

        if ($this->search) {
            $query->where($this->filterBy, 'like', '%'.strtolower($this->search).'%');

        }
        return $query->paginate(8,['*'], 'attachedProdPage')?? new \Illuminate\Pagination\LengthAwarePaginator([], 0, 8);;
    }

    public function getAttachedProductsProperty()
    {
        $storeId = auth()->user()?->storeInstallation?->id;

        $rate = RateDetails::find($this->rateDetailsId);
        return $rate
            ? $rate->products()
                ->where('store_id', $storeId)
                ->paginate(8, ['*'], 'attachedPage')
            : new \Illuminate\Pagination\LengthAwarePaginator([], 0, 8);

    }

    public function render()
    {
        return view('bigcommerce::livewire.bigcommerce.rates.product-rate-attachment', [
            'products' => $this->filteredProducts,
            'attachedProducts' => $this->attachedProducts,
            'showDrawer' => $this->showDrawer,
        ]);
    }
}
