<div class="flex h-full w-full flex-1 flex-col gap-6 rounded-xl">
    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-zinc-900 dark:text-white">BigCommerce Shipping Rates</h2>
            <p class="text-sm text-zinc-500 dark:text-zinc-400">Documentation and user guide</p>
        </div>
    </div>

    <!-- Quick Navigation -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <a href="#import-products" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-green-500 dark:hover:border-green-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-100 dark:bg-green-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-600 dark:text-green-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-green-600 dark:group-hover:text-green-400">Import Products</span>
            </div>
        </a>
        <a href="#carriers" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-blue-500 dark:hover:border-blue-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-blue-600 dark:text-blue-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-blue-600 dark:group-hover:text-blue-400">Carriers</span>
            </div>
        </a>
        <a href="#rules" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-purple-500 dark:hover:border-purple-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-purple-600 dark:text-purple-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 11-3 0m3 0a1.5 1.5 0 10-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-9.75 0h9.75" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-purple-600 dark:group-hover:text-purple-400">Shipping Rules</span>
            </div>
        </a>
        <a href="#troubleshooting" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-700 dark:bg-zinc-900 hover:border-red-500 dark:hover:border-red-500 transition-colors group">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-red-100 dark:bg-red-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-red-600 dark:text-red-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.42 15.17L17.25 21A2.652 2.652 0 0021 17.25l-5.877-5.877M11.42 15.17l2.496-3.03c.317-.384.74-.626 1.208-.766M11.42 15.17l-4.655 5.653a2.548 2.548 0 11-3.586-3.586l6.837-5.63m5.108-.233c.55-.164 1.163-.188 1.743-.14a4.5 4.5 0 004.486-6.336l-3.276 3.277a3.004 3.004 0 01-2.25-2.25l3.276-3.276a4.5 4.5 0 00-6.336 4.486c.091 1.076-.071 2.264-.904 2.95l-.102.085m-1.745 1.437L5.909 7.5H4.5L2.25 3.75l1.5-1.5L7.5 4.5v1.409l4.26 4.26m-1.745 1.437l1.745-1.437m6.615 8.206L15.75 15.75M4.867 19.125h.008v.008h-.008v-.008z" />
                    </svg>
                </div>
                <span class="font-medium text-zinc-900 dark:text-white group-hover:text-red-600 dark:group-hover:text-red-400">Troubleshooting</span>
            </div>
        </a>
    </div>

    <!-- Getting Started Section -->
    <section class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Getting Started</h3>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                The BigCommerce Shipping Rates package provides live shipping rate calculations for your BigCommerce store. Follow these steps to set up your shipping configuration:
            </p>
            <div class="grid md:grid-cols-3 gap-4">
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <div class="w-8 h-8 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center text-sm font-bold text-green-700 dark:text-green-400">1</div>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Import Products</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Sync your BigCommerce product catalog</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/30 rounded-full flex items-center justify-center text-sm font-bold text-blue-700 dark:text-blue-400">2</div>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Set Up Carriers</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Configure shipping carriers and rates</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <div class="w-8 h-8 bg-purple-100 dark:bg-purple-900/30 rounded-full flex items-center justify-center text-sm font-bold text-purple-700 dark:text-purple-400">3</div>
                    <div>
                        <h4 class="font-medium text-zinc-900 dark:text-white">Create Rules</h4>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Define shipping rules for your products</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Import Products Section -->
    <section id="import-products" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-green-100 dark:bg-green-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-green-600 dark:text-green-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Import Products</h3>
            </div>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                The Import Products feature allows you to sync your BigCommerce product catalog with the shipping rates system. This enables product-specific shipping rules based on categories, custom fields, and other product attributes.
            </p>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">How to Import Products</h4>
            <div class="space-y-4 mb-6">
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <span class="w-6 h-6 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center text-xs font-bold text-green-700 dark:text-green-400">1</span>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Navigate to Import Products</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Click "Import Products" in the sidebar menu</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <span class="w-6 h-6 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center text-xs font-bold text-green-700 dark:text-green-400">2</span>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Start Import</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Click the "Import" button to begin syncing products from your BigCommerce store</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <span class="w-6 h-6 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center text-xs font-bold text-green-700 dark:text-green-400">3</span>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Wait for Completion</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">The import process runs in the background. You'll see a progress indicator and completion message</p>
                    </div>
                </div>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">What Gets Imported</h4>
            <div class="grid md:grid-cols-2 gap-4">
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Product Details</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Name, SKU, price, weight, dimensions</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Categories</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Product category assignments</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Custom Fields</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">All custom fields (e.g., "pallet", "item type")</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-500 mt-0.5 flex-shrink-0">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Product Options</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Configurable options (e.g., "free sample")</p>
                    </div>
                </div>
            </div>

            <div class="mt-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700/50 rounded-lg p-4">
                <div class="flex items-start gap-3">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z" />
                    </svg>
                    <div>
                        <h5 class="font-medium text-blue-800 dark:text-blue-300">Tip: Re-import Regularly</h5>
                        <p class="text-sm text-blue-700 dark:text-blue-200/80">Run the import periodically to keep your product data in sync, especially after adding new products or updating custom fields in BigCommerce.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Carriers Section -->
    <section id="carriers" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-blue-600 dark:text-blue-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Carriers & Rates</h3>
            </div>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                Carriers represent shipping providers (e.g., DPD, FedEx, Royal Mail). Each carrier can have multiple shipping rates with different prices and delivery options.
            </p>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Creating a Carrier</h4>
            <div class="space-y-4 mb-6">
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <span class="w-6 h-6 bg-blue-100 dark:bg-blue-900/30 rounded-full flex items-center justify-center text-xs font-bold text-blue-700 dark:text-blue-400">1</span>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Navigate to Carrier</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Click "Carrier" in the sidebar menu</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <span class="w-6 h-6 bg-blue-100 dark:bg-blue-900/30 rounded-full flex items-center justify-center text-xs font-bold text-blue-700 dark:text-blue-400">2</span>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Add New Carrier</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Click "Add Carrier" and enter the carrier code and display name</p>
                    </div>
                </div>
                <div class="flex items-start gap-3 p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg">
                    <span class="w-6 h-6 bg-blue-100 dark:bg-blue-900/30 rounded-full flex items-center justify-center text-xs font-bold text-blue-700 dark:text-blue-400">3</span>
                    <div>
                        <h5 class="font-medium text-zinc-900 dark:text-white">Add Rates</h5>
                        <p class="text-sm text-zinc-500 dark:text-zinc-400">Add one or more shipping rates to the carrier with code, name, and price</p>
                    </div>
                </div>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Carrier Fields</h4>
            <div class="overflow-x-auto mb-6">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b border-zinc-200 dark:border-zinc-700">
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Field</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Description</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Example</th>
                        </tr>
                    </thead>
                    <tbody class="text-zinc-600 dark:text-zinc-300">
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4 font-medium">Carrier Code</td>
                            <td class="py-3 px-4">Unique identifier for the carrier</td>
                            <td class="py-3 px-4"><code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">DPD_UK</code></td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4 font-medium">Display Name</td>
                            <td class="py-3 px-4">Name shown to customers at checkout</td>
                            <td class="py-3 px-4">DPD UK Shipping</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Rate Fields</h4>
            <div class="overflow-x-auto mb-6">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b border-zinc-200 dark:border-zinc-700">
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Field</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Description</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Example</th>
                        </tr>
                    </thead>
                    <tbody class="text-zinc-600 dark:text-zinc-300">
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4 font-medium">Rate Code</td>
                            <td class="py-3 px-4">Unique identifier used in shipping rules</td>
                            <td class="py-3 px-4"><code class="text-xs bg-zinc-100 dark:bg-zinc-800 px-1.5 py-0.5 rounded">std_delivery</code></td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4 font-medium">Display Name</td>
                            <td class="py-3 px-4">Name shown to customers</td>
                            <td class="py-3 px-4">Standard Delivery</td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4 font-medium">Currency</td>
                            <td class="py-3 px-4">Currency for the rate price</td>
                            <td class="py-3 px-4">GBP, USD, EUR</td>
                        </tr>
                        <tr>
                            <td class="py-3 px-4 font-medium">Amount</td>
                            <td class="py-3 px-4">Shipping cost</td>
                            <td class="py-3 px-4">9.99</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-700/50 rounded-lg p-4">
                <div class="flex items-start gap-3">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-amber-600 dark:text-amber-400 flex-shrink-0 mt-0.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                    </svg>
                    <div>
                        <h5 class="font-medium text-amber-800 dark:text-amber-300">Important: Rate Codes</h5>
                        <p class="text-sm text-amber-700 dark:text-amber-200/80">Rate codes are used in shipping rules to include or exclude specific rates. Use descriptive codes like <code class="bg-amber-100 dark:bg-amber-800/50 px-1 rounded">sample_shipping</code>, <code class="bg-amber-100 dark:bg-amber-800/50 px-1 rounded">pallet_delivery</code>, or <code class="bg-amber-100 dark:bg-amber-800/50 px-1 rounded">free_delivery</code>.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Shipping Rules Section -->
    <section id="rules" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-purple-600 dark:text-purple-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 11-3 0m3 0a1.5 1.5 0 10-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-9.75 0h9.75" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Shipping Rules</h3>
            </div>
        </div>
        <div class="p-6">
            <p class="text-zinc-600 dark:text-zinc-300 mb-6">
                Shipping rules control which rates are shown to customers based on cart contents. Rules are evaluated in priority order, and the first matching rule's actions are applied.
            </p>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Rule Components</h4>
            <div class="grid md:grid-cols-2 gap-4 mb-6">
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-2">Basic Information</h5>
                    <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                        <li>* <strong>Name</strong> - Descriptive rule name</li>
                        <li>* <strong>Priority</strong> - Evaluation order (lower = first)</li>
                        <li>* <strong>Enabled</strong> - Active/inactive toggle</li>
                        <li>* <strong>Match Type</strong> - ALL or ANY items must match</li>
                    </ul>
                </div>
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-2">Conditions (WHEN)</h5>
                    <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                        <li>* Define criteria for rule activation</li>
                        <li>* Check cart, item, product data</li>
                        <li>* Use AND/OR logic for complex rules</li>
                    </ul>
                </div>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Condition Field Sources</h4>
            <div class="overflow-x-auto mb-6">
                <table class="w-full text-sm">
                    <thead>
                        <tr class="border-b border-zinc-200 dark:border-zinc-700">
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Source</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Description</th>
                            <th class="text-left py-3 px-4 font-semibold text-zinc-900 dark:text-white">Fields</th>
                        </tr>
                    </thead>
                    <tbody class="text-zinc-600 dark:text-zinc-300">
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4"><span class="px-2 py-0.5 bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300 rounded text-xs font-medium">Cart</span></td>
                            <td class="py-3 px-4">Shipping destination info</td>
                            <td class="py-3 px-4">country_iso2, state, city, postal_code</td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4"><span class="px-2 py-0.5 bg-green-100 dark:bg-green-900/30 text-green-700 dark:text-green-300 rounded text-xs font-medium">Item</span></td>
                            <td class="py-3 px-4">Line item data</td>
                            <td class="py-3 px-4">quantity, sku, name, price</td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4"><span class="px-2 py-0.5 bg-amber-100 dark:bg-amber-900/30 text-amber-700 dark:text-amber-300 rounded text-xs font-medium">Product</span></td>
                            <td class="py-3 px-4">Product catalog data</td>
                            <td class="py-3 px-4">categories, brand_id, weight</td>
                        </tr>
                        <tr class="border-b border-zinc-100 dark:border-zinc-800">
                            <td class="py-3 px-4"><span class="px-2 py-0.5 bg-cyan-100 dark:bg-cyan-900/30 text-cyan-700 dark:text-cyan-300 rounded text-xs font-medium">Option</span></td>
                            <td class="py-3 px-4">Customer-selected options</td>
                            <td class="py-3 px-4 italic">Enter name (e.g., "free sample")</td>
                        </tr>
                        <tr>
                            <td class="py-3 px-4"><span class="px-2 py-0.5 bg-pink-100 dark:bg-pink-900/30 text-pink-700 dark:text-pink-300 rounded text-xs font-medium">Custom Field</span></td>
                            <td class="py-3 px-4">Product custom fields</td>
                            <td class="py-3 px-4 italic">Enter name (e.g., "pallet", "item type")</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Actions (THEN)</h4>
            <div class="grid md:grid-cols-2 gap-4 mb-6">
                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-700/50 rounded-lg p-4">
                    <div class="flex items-center gap-2 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-green-600 dark:text-green-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <h5 class="font-medium text-green-800 dark:text-green-300">Include Rates</h5>
                    </div>
                    <p class="text-sm text-green-700 dark:text-green-200/80">Only show rates matching the pattern. All other rates are hidden.</p>
                </div>
                <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-700/50 rounded-lg p-4">
                    <div class="flex items-center gap-2 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-5 h-5 text-red-600 dark:text-red-400">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                        </svg>
                        <h5 class="font-medium text-red-800 dark:text-red-300">Exclude Rates</h5>
                    </div>
                    <p class="text-sm text-red-700 dark:text-red-200/80">Hide rates matching the pattern. All other rates are shown.</p>
                </div>
            </div>

            <h4 class="font-semibold text-zinc-900 dark:text-white mb-4">Rule Examples</h4>
            <div class="space-y-3">
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-1">Free Sample Shipping</h5>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-2">Show only sample rates when all items have "free sample" option = "yes"</p>
                    <div class="text-sm text-zinc-600 dark:text-zinc-300">
                        <span class="text-purple-600 dark:text-purple-400">Condition:</span> Option "free sample" equals "yes" |
                        <span class="text-green-600 dark:text-green-400">Action:</span> Include rates containing "sample"
                    </div>
                </div>
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-1">Pallet Shipping</h5>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-2">Show pallet rates when any item has custom field "pallet" = "T"</p>
                    <div class="text-sm text-zinc-600 dark:text-zinc-300">
                        <span class="text-purple-600 dark:text-purple-400">Condition:</span> Custom Field "pallet" equals "T" |
                        <span class="text-green-600 dark:text-green-400">Action:</span> Include "pallet", <span class="text-red-600 dark:text-red-400">Exclude</span> "sample", "free"
                    </div>
                </div>
                <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                    <h5 class="font-medium text-zinc-900 dark:text-white mb-1">Standard Shipping (Default)</h5>
                    <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-2">Fallback rule (priority 99) - hide special rates for regular orders</p>
                    <div class="text-sm text-zinc-600 dark:text-zinc-300">
                        <span class="text-purple-600 dark:text-purple-400">Condition:</span> None (always matches) |
                        <span class="text-red-600 dark:text-red-400">Action:</span> Exclude "sample", "free", "accessory"
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Troubleshooting Section -->
    <section id="troubleshooting" class="relative overflow-hidden rounded-xl border border-zinc-200 bg-white dark:border-zinc-700 dark:bg-zinc-900">
        <div class="border-b border-zinc-200 px-6 py-4 dark:border-zinc-700">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-red-100 dark:bg-red-900/30 rounded-lg flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-4 h-4 text-red-600 dark:text-red-400">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.42 15.17L17.25 21A2.652 2.652 0 0021 17.25l-5.877-5.877M11.42 15.17l2.496-3.03c.317-.384.74-.626 1.208-.766M11.42 15.17l-4.655 5.653a2.548 2.548 0 11-3.586-3.586l6.837-5.63m5.108-.233c.55-.164 1.163-.188 1.743-.14a4.5 4.5 0 004.486-6.336l-3.276 3.277a3.004 3.004 0 01-2.25-2.25l3.276-3.276a4.5 4.5 0 00-6.336 4.486c.091 1.076-.071 2.264-.904 2.95l-.102.085m-1.745 1.437L5.909 7.5H4.5L2.25 3.75l1.5-1.5L7.5 4.5v1.409l4.26 4.26m-1.745 1.437l1.745-1.437m6.615 8.206L15.75 15.75M4.867 19.125h.008v.008h-.008v-.008z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Troubleshooting</h3>
            </div>
        </div>
        <div class="p-6 space-y-4">
            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">No shipping rates at checkout</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Verify carriers and rates are configured in the Carrier section</li>
                    <li>* Check that at least one shipping rule matches the cart</li>
                    <li>* Ensure actions aren't excluding all available rates</li>
                </ul>
            </div>

            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">Wrong rates showing</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Check rule priorities - lower numbers are evaluated first</li>
                    <li>* Only the FIRST matching rule's actions are applied</li>
                    <li>* Verify conditions use correct field source and operator</li>
                </ul>
            </div>

            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">Condition not matching</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Check if "Case sensitive" is enabled when it shouldn't be</li>
                    <li>* Verify exact spelling of option/custom field names</li>
                    <li>* Use "contains" instead of "equals" for partial matches</li>
                    <li>* Re-import products if custom fields were recently updated</li>
                </ul>
            </div>

            <div class="bg-zinc-50 dark:bg-zinc-800 rounded-lg p-4">
                <h4 class="font-medium text-zinc-900 dark:text-white mb-2">Products not showing updated data</h4>
                <ul class="text-sm text-zinc-600 dark:text-zinc-300 space-y-1">
                    <li>* Run the Import Products process to sync latest data</li>
                    <li>* Check that custom fields exist in BigCommerce</li>
                    <li>* Verify product options are configured correctly</li>
                </ul>
            </div>
        </div>
    </section>
</div>
