<?php

    namespace Mtc\BigCommerceRates\Models\BigCommerce;

    use Illuminate\Database\Eloquent\Model;
    use Mtc\BigCommerceRates\Models\StoreInstallation;

    class Product extends Model
    {
        // Table name (optional if Laravel's convention works, but explicit is clearer)
        protected $table = 'store_product';

        // Mass-assignable attributes
        protected $fillable = [
            'store_id',
            'sku',
            'product_id',
            'name',
            'price',
            'custom_fields',
        ];

        // Casts
        protected $casts = [
            'custom_fields' => 'array', // Assuming custom_fields is JSON-like string or array
        ];

        /**
         * Get the store installation that owns the product.
         */
        public function storeInstallation()
        {
            return $this->belongsTo(StoreInstallation::class, 'store_id');
        }
    }
