<?php

use Mtc\Checkout\Factories\SplitInvoiceFactory;

return [
    /*
    |--------------------------------------------------------------------------
    | Invoice templates
    |--------------------------------------------------------------------------
    |
    | Path to default invoice template used to render an invoice
    |
    */

    'default_template' => 'invoices/default.twig',

    'invoice_templates' => [
        'invoices/default.twig' => 'Default Template',
        'invoices/default2.twig' => 'Second Template',
    ],

    /*
    |--------------------------------------------------------------------------
    | Invoice Reference
    |--------------------------------------------------------------------------
    |
    | By default we set the invoice id as reference.
    | However we can use the payable reference as well if needed.
    |
    */

    'use_id_for_reference' => true,

    /*
    |--------------------------------------------------------------------------
    | Show a note field for invoice
    |--------------------------------------------------------------------------
    |
    | If enabled invoice show page will have a field for adding notes on invoice
    | These notes then can be used to display on invoice print template as
    | {{ invoice.details.note }}
    |
    */

    'editable_note_field' => true,

    /*
    |--------------------------------------------------------------------------
    | Seller Address
    |--------------------------------------------------------------------------
    |
    | This address will be generated for the seller part of the invoice
    |
    */
    'seller_address' => [
        'type' => 'seller',
        'first_name' => '',
        'last_name' => '',
        'address1' => '',
        'address2' => '',
        'city' => '',
        'postcode' => '',
        'country' => 'GB',
    ],

    /*
    |--------------------------------------------------------------------------
    | Admin configuration
    |--------------------------------------------------------------------------
    |
    | Customise admin section
    |
    */
    'admin' => [
        'pagination' => 20
    ],

    'admin_search_filters' => [
        \Mtc\Orders\Filters\FilterById::class,
        \Mtc\Foundation\Filters\FilterByEmail::class,
        \Mtc\Checkout\Filters\FilterByStatus::class,
        \Mtc\Checkout\Filters\FilterByUnpaidOrders::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Invoice Splitting
    |--------------------------------------------------------------------------
    |
    | Select a factory that will be used for splitting invoices into two
    |
    */
    'split_invoice_factory' => SplitInvoiceFactory::class,
];
